/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.common.dependency;

import dev.id2r.api.common.dependency.DynamicDependency;
import dev.id2r.api.common.dependency.relocation.Relocation;
import dev.id2r.api.common.dependency.relocation.RelocationHelper;
import dev.id2r.api.common.plugin.logging.PluginLogger;
import dev.id2r.api.common.utils.ByteUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Objects;

public abstract class DependencyManager {
    private final Path saveDirectory;
    private final PluginLogger logger;
    private RelocationHelper relocator;

    public DependencyManager(PluginLogger logger, Path dataDirectory) {
        this.logger = logger;
        this.saveDirectory = Objects.requireNonNull(dataDirectory, "dataDirectory").toAbsolutePath().resolve("lib");
    }

    protected abstract void addToClasspath(Path var1);

    public Path downloadDependency(DynamicDependency dependency) {
        Path path;
        MessageDigest digest;
        Path file = this.saveDirectory.resolve(Objects.requireNonNull(dependency, "library").getPath());
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        if (dependency.getVendor() == null) {
            throw new RuntimeException("dependency requested to be download doesn't have a vendor.");
        }
        if (dependency.getCheckSum() == null) {
            throw new RuntimeException("Prevented dependency download because it doesn't have an original check sum to check for imposter jars");
        }
        String url = dependency.url();
        byte[] checksum = dependency.getCheckSum();
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("failed to load SHA-256 algorithm.", e);
        }
        Path out = file.resolveSibling(file.getFileName() + ".tmp");
        out.toFile().deleteOnExit();
        try {
            byte[] downloaded_checksum;
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            byte[] bytes = this.downloadRaw(url);
            if (digest != null && !Arrays.equals(downloaded_checksum = digest.digest(bytes), checksum)) {
                this.logger.warn("*** INVALID CHECKSUM ***");
                this.logger.warn(" Dependency :  " + dependency);
                this.logger.warn(" URL :  " + url);
                this.logger.warn(" Expected :  " + Base64.getEncoder().encodeToString(checksum));
                this.logger.warn(" Actual :  " + Base64.getEncoder().encodeToString(downloaded_checksum));
                Path path2 = null;
                return path2;
            }
            Files.write(out, bytes, new OpenOption[0]);
            Files.move(out, file, new CopyOption[0]);
            path = file;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                Files.deleteIfExists(out);
            }
            catch (IOException iOException) {}
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] downloadRaw(String url) {
        try {
            URLConnection connection = this.openConnection(url);
            try (InputStream in = connection.getInputStream();){
                byte[] bytes = ByteUtil.toByteArray(in);
                if (bytes.length == 0) {
                    throw new RuntimeException("Empty stream");
                }
                byte[] byArray = bytes;
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("failed to download");
        }
    }

    private URLConnection openConnection(String url) throws IOException {
        URL dependencyUrl = new URL(url);
        return dependencyUrl.openConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path relocate(Path in, String out, Collection<Relocation> relocations) {
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(out, "out");
        Objects.requireNonNull(relocations, "relocations");
        Path file = this.saveDirectory.resolve(out);
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        Path tmpOut = file.resolveSibling(file.getFileName() + ".tmp");
        tmpOut.toFile().deleteOnExit();
        Object object = this;
        synchronized (object) {
            if (this.relocator == null) {
                this.relocator = new RelocationHelper(this);
            }
        }
        try {
            this.relocator.relocate(in, tmpOut, relocations);
            Files.move(tmpOut, file, new CopyOption[0]);
            this.logger.info("Relocations applied to " + this.saveDirectory.getParent().relativize(in));
            object = file;
            return object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to relocate jar: " + in, e);
        }
        finally {
            try {
                Files.deleteIfExists(tmpOut);
            }
            catch (IOException iOException) {}
        }
    }

    public void loadLibrary(DynamicDependency dependency) {
        Path file = this.downloadDependency(Objects.requireNonNull(dependency, "library"));
        if (dependency.hasRelocations()) {
            file = this.relocate(file, dependency.getRelocatedPath(), dependency.getRelocations());
        }
        this.addToClasspath(file);
    }
}

