/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.common.utils;

import java.util.concurrent.TimeUnit;

public class StringUtils {
    public static String translateAlternateColorCodes(char altColorChar, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRr".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static String translateMessage(String message) {
        return StringUtils.translateAlternateColorCodes('&', message);
    }

    public static String translateTime(long timeMilli) {
        TimeUnit unit = TimeUnit.MILLISECONDS;
        long seconds = unit.toSeconds(timeMilli) % 60L;
        long minutes = unit.toMinutes(timeMilli) % 60L;
        long hours = unit.toHours(timeMilli) % 24L;
        long days = unit.toDays(timeMilli);
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append(" day(s) ");
        }
        if (hours > 0L) {
            builder.append(hours).append(" hour(s) ");
        }
        if (minutes > 0L) {
            builder.append(minutes).append(" minute(s) ");
        }
        builder.append(seconds).append(" second(s) ");
        return builder.toString();
    }
}

