/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.common.dependency.relocation;

import dev.id2r.api.common.dependency.DependencyManager;
import dev.id2r.api.common.dependency.DynamicDependency;
import dev.id2r.api.common.dependency.classloader.IsolatedClassLoader;
import dev.id2r.api.common.dependency.relocation.Relocation;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RelocationHelper {
    private static final String JAR_RELOCATOR_CLASS = "me.lucko.jarrelocator.JarRelocator";
    private static final String JAR_RELOCATOR_RUN_METHOD = "run";
    private final Constructor<?> jarRelocatorConstructor;
    private final Method jarRelocatorRunMethod;

    public RelocationHelper(DependencyManager manager) {
        IsolatedClassLoader classLoader = new IsolatedClassLoader(new URL[0]);
        classLoader.addPath(manager.downloadDependency(DynamicDependency.newBuilder().info("org.ow2.asm", "asm-commons", "9.1").checkSum("r8sm3B/BLAxKma2mcJCN2C4Y38SIyvXuklRplrRwwAw=").create()));
        classLoader.addPath(manager.downloadDependency(DynamicDependency.newBuilder().info("org.ow2.asm", "asm", "9.1").checkSum("zaTeRV+rSP8Ly3xItGOUR9TehZp6/DCglKmG8JNr66I=").create()));
        classLoader.addPath(manager.downloadDependency(DynamicDependency.newBuilder().info("me.lucko", "jar-relocator", "1.4").checkSum("1RsiF3BiVztjlfTA+svDCuoDSGFuSpTZYHvUK8yBx8I=").create()));
        try {
            Class<?> jarRelocatorClass = classLoader.loadClass(JAR_RELOCATOR_CLASS);
            this.jarRelocatorConstructor = jarRelocatorClass.getDeclaredConstructor(File.class, File.class, Map.class);
            this.jarRelocatorConstructor.setAccessible(true);
            this.jarRelocatorRunMethod = jarRelocatorClass.getDeclaredMethod(JAR_RELOCATOR_RUN_METHOD, new Class[0]);
            this.jarRelocatorRunMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void relocate(Path in, Path out, Collection<Relocation> relocations) throws Exception {
        Objects.requireNonNull(in, "in");
        Objects.requireNonNull(out, "out");
        Objects.requireNonNull(relocations, "relocations");
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (Relocation relocation : relocations) {
            mappings.put(relocation.getPattern(), relocation.getRelocatedPattern());
        }
        Object relocator = this.jarRelocatorConstructor.newInstance(in.toFile(), out.toFile(), mappings);
        this.jarRelocatorRunMethod.invoke(relocator, new Object[0]);
    }
}

