/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.common.dependency.classloader;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Objects;

public class URLClassLoaderHelper {
    private final URLClassLoader classLoader;
    private final Method addURLMethod;

    public URLClassLoaderHelper(URLClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
        try {
            this.addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            this.addURLMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void addToClasspath(URL url) {
        try {
            this.addURLMethod.invoke((Object)this.classLoader, Objects.requireNonNull(url, "url"));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void addToClasspath(Path path) {
        try {
            this.addToClasspath(Objects.requireNonNull(path, "path").toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

