/*
 * Decompiled with CFR 0.152.
 */
package dev.id2r.api.bungee;

import dev.id2r.api.bungee.BungeePlugin;
import dev.id2r.api.bungee.BungeeTaskAdapter;
import dev.id2r.api.common.platform.Platform;
import dev.id2r.api.common.plugin.bootstrap.ID2RPluginBootstrap;
import dev.id2r.api.common.plugin.bootstrap.LoaderBootstrap;
import dev.id2r.api.common.plugin.logging.JUtilPluginLogger;
import dev.id2r.api.common.plugin.logging.PluginLogger;
import dev.id2r.api.common.plugin.task.TaskFactory;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeeBootstrap
implements ID2RPluginBootstrap,
LoaderBootstrap {
    private final Plugin loader;
    private final BungeePlugin plugin;
    private final BungeeTaskAdapter taskAdapter;
    private PluginLogger logger;
    private Instant startTime;

    public BungeeBootstrap(Plugin loader, BungeePlugin plugin) {
        this.loader = loader;
        this.plugin = plugin;
        this.taskAdapter = new BungeeTaskAdapter(this);
    }

    public final Plugin getLoader() {
        return this.loader;
    }

    public final ProxyServer getProxy() {
        return this.loader.getProxy();
    }

    public void load() {
        this.logger = new JUtilPluginLogger(this.loader.getLogger());
        this.startTime = Instant.now();
        this.plugin.onLoad();
    }

    public void enable() {
        this.plugin.onEnable();
    }

    public void disable() {
        this.plugin.onDisable();
    }

    public PluginLogger getLogger() {
        return this.logger;
    }

    public TaskFactory getTaskFactory() {
        return this.taskAdapter;
    }

    public String getVersion() {
        return this.getProxy().getVersion();
    }

    public Instant getStartupTime() {
        return this.startTime;
    }

    public Platform.Type getPlatformType() {
        return Platform.Type.BUNGEECORD;
    }

    public Path getDataDirectory() {
        return this.loader.getDataFolder().toPath().toAbsolutePath();
    }

    public int getPlayerCount() {
        return this.loader.getProxy().getOnlineCount();
    }

    public Collection<String> getPlayerList() {
        Collection players = this.getProxy().getPlayers();
        ArrayList<String> list = new ArrayList<String>(players.size());
        for (ProxiedPlayer player : players) {
            list.add(player.getName());
        }
        return list;
    }

    public Collection<UUID> getOnlinePlayers() {
        Collection players = this.getProxy().getPlayers();
        ArrayList<UUID> list = new ArrayList<UUID>(players.size());
        for (ProxiedPlayer player : players) {
            list.add(player.getUniqueId());
        }
        return list;
    }

    public boolean isPlayerOnline(UUID uniqueId) {
        return this.getProxy().getPlayer(uniqueId) != null;
    }

    public Optional<ProxiedPlayer> getPlayer(UUID uuid) {
        return Optional.ofNullable(this.getProxy().getPlayer(uuid));
    }
}

