/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.posthog;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.hollowcube.posthog.FeatureFlagContext;
import net.hollowcube.posthog.FeatureFlagState;
import net.hollowcube.posthog.FeatureFlagStates;
import net.hollowcube.posthog.PostHogClientImpl;
import net.hollowcube.posthog.PostHogClientNoop;
import net.hollowcube.posthog.PostHogNames;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface PostHogClient
permits PostHogClientImpl, PostHogClientNoop {
    @NotNull
    public static PostHogClient noopPostHogClient() {
        return new PostHogClientNoop();
    }

    @NotNull
    public static PostHogClient newPostHogClient(@NotNull String projectApiKey) {
        return new Builder(projectApiKey).build();
    }

    @NotNull
    public static Builder newBuilder(@NotNull String projectApiKey) {
        return new Builder(projectApiKey);
    }

    @Blocking
    public void shutdown(@NotNull Duration var1);

    default public void capture(@NotNull String distinctId, @NotNull String event) {
        this.capture(distinctId, event, Map.of());
    }

    default public void capture(@NotNull String distinctId, @NotNull String event, @NotNull Map<String, Object> properties) {
        this.capture(distinctId, event, (Object)properties);
    }

    public void capture(@NotNull String var1, @NotNull String var2, @NotNull Object var3);

    default public void identify(@NotNull String distinctId, @Nullable Map<String, Object> properties, @Nullable Map<String, Object> propertiesSetOnce) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        if (properties != null) {
            eventProps.put("$set", properties);
        }
        if (propertiesSetOnce != null) {
            eventProps.put("$set_once", propertiesSetOnce);
        }
        this.capture(distinctId, "$identify", eventProps);
    }

    default public void identify(@NotNull String distinctId, @Nullable Object properties, @Nullable Object propertiesSetOnce) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        if (properties != null) {
            eventProps.put("$set", properties);
        }
        if (propertiesSetOnce != null) {
            eventProps.put("$set_once", propertiesSetOnce);
        }
        this.capture(distinctId, "$identify", eventProps);
    }

    default public void identify(@NotNull String distinctId, @Nullable Map<String, Object> properties) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        if (properties != null) {
            eventProps.put("$set", properties);
        }
        this.capture(distinctId, "$identify", eventProps);
    }

    default public void identify(@NotNull String distinctId, @Nullable Object properties) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        if (properties != null) {
            eventProps.put("$set", properties);
        }
        this.capture(distinctId, "$identify", eventProps);
    }

    default public void alias(@NotNull String distinctId, @NotNull String alias) {
        this.capture(distinctId, "$create_alias", Map.of("distinct_id", Objects.requireNonNull(distinctId), "alias", Objects.requireNonNull(alias)));
    }

    default public void groupIdentify(@NotNull String type, @NotNull String key, @NotNull Map<String, Object> properties) {
        this.groupIdentify(type, key, (Object)properties);
    }

    default public void groupIdentify(@NotNull String type, @NotNull String key, @NotNull Object properties) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        eventProps.put("$group_type", PostHogNames.nonNullNonEmpty("type", type));
        eventProps.put("$groupkey", PostHogNames.nonNullNonEmpty("key", key));
        eventProps.put("$group_set", Objects.requireNonNull(properties));
        String distinctId = String.format("%s_%s", type, key);
        this.capture(distinctId, "$groupidentify", eventProps);
    }

    public void flush();

    default public boolean isFeatureEnabled(@NotNull String key, @NotNull String distinctId) {
        return this.getFeatureFlag(key, distinctId, null).isEnabled();
    }

    default public boolean isFeatureEnabled(@NotNull String key, @NotNull String distinctId, @Nullable FeatureFlagContext context) {
        return this.getFeatureFlag(key, distinctId, context).isEnabled();
    }

    @NotNull
    default public FeatureFlagState getFeatureFlag(@NotNull String key, @NotNull String distinctId) {
        return this.getFeatureFlag(key, distinctId, null);
    }

    @NotNull
    public FeatureFlagState getFeatureFlag(@NotNull String var1, @NotNull String var2, @Nullable FeatureFlagContext var3);

    @NotNull
    default public FeatureFlagStates getAllFeatureFlags(@NotNull String distinctId) {
        return this.getAllFeatureFlags(distinctId, null);
    }

    @NotNull
    public FeatureFlagStates getAllFeatureFlags(@NotNull String var1, @Nullable FeatureFlagContext var2);

    public void reloadFeatureFlags();

    default public void captureException(@NotNull Throwable throwable) {
        this.captureException(throwable, null, (Object)null);
    }

    default public void captureException(@NotNull Throwable throwable, @NotNull String distinctId) {
        this.captureException(throwable, distinctId, (Object)null);
    }

    default public void captureException(@NotNull Throwable throwable, @NotNull String distinctId, @NotNull Map<String, Object> properties) {
        this.captureException(throwable, distinctId, (Object)properties);
    }

    public void captureException(@NotNull Throwable var1, @Nullable String var2, @Nullable Object var3);

    public static final class Builder {
        private final String projectApiKey;
        private String endpoint = "https://app.posthog.com";
        private String personalApiKey = null;
        private Duration flushInterval = Duration.ofSeconds(5L);
        private int maxBatchSize = 250;
        private Map<String, Object> defaultEventProperties = new HashMap<String, Object>();
        private Duration eventBatchTimeout = Duration.ofSeconds(30L);
        private boolean allowRemoteFeatureFlagEvaluation = true;
        private boolean sendFeatureFlagEvents = false;
        private Duration featureFlagsPollingInterval = Duration.ofMinutes(5L);
        private Duration featureFlagsRequestTimeout = Duration.ofSeconds(3L);
        private Gson gson = null;

        private Builder(@NotNull String projectApiKey) {
            this.projectApiKey = Objects.requireNonNull(projectApiKey);
        }

        @Contract(pure=true)
        @NotNull
        public Builder endpoint(@NotNull String endpoint) {
            this.endpoint = Objects.requireNonNull(endpoint);
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder personalApiKey(@NotNull String personalApiKey) {
            this.personalApiKey = Objects.requireNonNull(personalApiKey);
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder flushInterval(@NotNull Duration flushInterval) {
            if (flushInterval.isNegative()) {
                throw new IllegalArgumentException("Flush interval must be positive");
            }
            this.flushInterval = Objects.requireNonNull(flushInterval);
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder maxBatchSize(int maxBatchSize) {
            if (maxBatchSize <= 0) {
                throw new IllegalArgumentException("Max batch size must be positive");
            }
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder defaultEventProperties(@NotNull Map<String, Object> defaultEventProperties) {
            this.defaultEventProperties = Objects.requireNonNull(defaultEventProperties);
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder eventBatchTimeout(@NotNull Duration eventBatchTimeout) {
            if (eventBatchTimeout.isNegative()) {
                throw new IllegalArgumentException("Event batch timeout must be positive");
            }
            this.eventBatchTimeout = Objects.requireNonNull(eventBatchTimeout);
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder allowRemoteFeatureFlagEvaluation(boolean allowRemoteFeatureFlagEvaluation) {
            this.allowRemoteFeatureFlagEvaluation = allowRemoteFeatureFlagEvaluation;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder sendFeatureFlagEvents(boolean sendFeatureFlagEvents) {
            this.sendFeatureFlagEvents = sendFeatureFlagEvents;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder featureFlagsPollingInterval(@NotNull Duration featureFlagsPollingInterval) {
            this.featureFlagsPollingInterval = Objects.requireNonNull(featureFlagsPollingInterval);
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder featureFlagsRequestTimeout(@NotNull Duration featureFlagsRequestTimeout) {
            this.featureFlagsRequestTimeout = Objects.requireNonNull(featureFlagsRequestTimeout);
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public Builder gson(@NotNull Gson gson) {
            this.gson = Objects.requireNonNull(gson);
            return this;
        }

        @NotNull
        public PostHogClient build() {
            Gson gson = Objects.requireNonNullElseGet(this.gson, () -> new GsonBuilder().disableJdkUnsafe().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create());
            return new PostHogClientImpl(gson, this.endpoint, this.projectApiKey, this.personalApiKey, this.flushInterval, this.maxBatchSize, this.defaultEventProperties, this.eventBatchTimeout, this.allowRemoteFeatureFlagEvaluation, this.sendFeatureFlagEvents, this.featureFlagsPollingInterval, this.featureFlagsRequestTimeout);
        }
    }
}

