/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.posthog;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.PatternSyntaxException;
import net.hollowcube.posthog.FeatureFlagContext;
import net.hollowcube.posthog.FeatureFlagState;
import net.hollowcube.posthog.FeatureFlagsResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class FeatureFlagEvaluator {
    @NotNull
    static FeatureFlagState evaluateFeatureFlag(@NotNull Gson gson, @NotNull FeatureFlagsResponse.Flag flag, @NotNull String distinctId, @NotNull FeatureFlagContext context) {
        if (flag.ensureExperienceContinuity() != null && flag.ensureExperienceContinuity().booleanValue()) {
            String reason = "Feature flag " + flag.key() + " requires experience continuity, cannot be evaluated locally";
            return new FeatureFlagState(false, null, reason);
        }
        if (!flag.active()) {
            return FeatureFlagState.DISABLED;
        }
        JsonObject personProperties = context.personProperties() == null ? new JsonObject() : gson.toJsonTree(context.personProperties()).getAsJsonObject();
        Map<String, Object> cohorts = Map.of();
        if (flag.filters().aggregationGroupTypeIndex() != null) {
            return new FeatureFlagState(false, null, "group evaluation not yet supported");
        }
        return FeatureFlagEvaluator.matchFeatureFlagProperties(flag, distinctId, personProperties, cohorts);
    }

    @NotNull
    private static FeatureFlagState matchFeatureFlagProperties(@NotNull FeatureFlagsResponse.Flag flag, @NotNull String distinctId, @NotNull JsonObject personProperties, @NotNull Map<String, Object> cohorts) {
        ArrayList<FeatureFlagsResponse.Condition> conditions = new ArrayList<FeatureFlagsResponse.Condition>(flag.filters().groups());
        conditions.sort((a, b) -> {
            int left = 1;
            int right = 1;
            if (a.variant() != null) {
                left = -1;
            }
            if (b.variant() != null) {
                right = -1;
            }
            return left - right;
        });
        FeatureFlagState fallthrough = FeatureFlagState.DISABLED;
        for (FeatureFlagsResponse.Condition condition : conditions) {
            FeatureFlagState match = FeatureFlagEvaluator.isConditionMatch(flag, distinctId, condition, personProperties, cohorts);
            if (match.isInconclusive()) {
                fallthrough = match;
            }
            if (!match.isEnabled()) continue;
            String variantOverride = condition.variant();
            FeatureFlagsResponse.Variants multivariates = flag.filters().multivariate();
            if (variantOverride != null && multivariates != null && FeatureFlagEvaluator.containsVariant(multivariates, variantOverride)) {
                return new FeatureFlagState(true, variantOverride, null);
            }
            FeatureFlagState result = FeatureFlagEvaluator.getMatchingVariant(flag, distinctId);
            String payload = flag.filters().payloads().get(Objects.requireNonNullElse(result.getVariant(), String.valueOf(result.isEnabled())));
            if (payload != null) {
                return new FeatureFlagState(result, payload);
            }
            return result;
        }
        return fallthrough;
    }

    @NotNull
    private static FeatureFlagState isConditionMatch(@NotNull FeatureFlagsResponse.Flag flag, @NotNull String distinctId, @NotNull FeatureFlagsResponse.Condition condition, @NotNull JsonObject personProperties, @NotNull Map<String, Object> cohorts) {
        List<FeatureFlagsResponse.Property> properties = condition.properties();
        if (properties != null && !condition.properties().isEmpty()) {
            for (FeatureFlagsResponse.Property property : properties) {
                FeatureFlagState match = "cohort".equals(property.type()) ? FeatureFlagEvaluator.matchCohort(property, personProperties, cohorts) : FeatureFlagEvaluator.matchProperty(property, personProperties);
                if (match.isEnabled()) continue;
                return match;
            }
        }
        if (condition.rolloutPercentage() != null) {
            return FeatureFlagEvaluator.checkIfSimpleFlagEnabled(flag.key(), distinctId, condition.rolloutPercentage());
        }
        return FeatureFlagState.ENABLED;
    }

    @NotNull
    private static FeatureFlagState matchCohort(@NotNull FeatureFlagsResponse.Property property, @NotNull JsonObject personProperties, @NotNull Map<String, Object> cohorts) {
        return new FeatureFlagState(false, null, "Cohort evaluation is not yet supported.");
    }

    @TestOnly
    @NotNull
    static FeatureFlagState matchProperty(@NotNull FeatureFlagsResponse.Property property, @NotNull JsonObject personProperties) {
        if (!personProperties.has(property.key())) {
            String reason = String.format("Cannot match against property without a given value (%s)", property.key());
            return new FeatureFlagState(false, null, reason);
        }
        JsonElement propertyValue = property.value();
        JsonElement personValue = personProperties.get(property.key());
        return switch (property.operator()) {
            case "is_not_set" -> {
                FeatureFlagState var6_7;
                yield var6_7 = new FeatureFlagState(false, null, "Cannot match is_not_set operator");
            }
            case "exact" -> {
                FeatureFlagState var6_8;
                yield var6_8 = new FeatureFlagState(propertyValue.isJsonArray() ? FeatureFlagEvaluator.contains(propertyValue.getAsJsonArray(), personValue) : propertyValue.equals(personValue));
            }
            case "is_not" -> {
                FeatureFlagState var6_9;
                yield var6_9 = new FeatureFlagState(propertyValue.isJsonArray() ? !FeatureFlagEvaluator.contains(propertyValue.getAsJsonArray(), personValue) : !propertyValue.equals(personValue));
            }
            case "is_set" -> {
                FeatureFlagState var6_10;
                yield var6_10 = FeatureFlagState.ENABLED;
            }
            case "icontains" -> {
                FeatureFlagState var6_11;
                yield var6_11 = new FeatureFlagState(FeatureFlagEvaluator.valueAsString(personValue).toLowerCase(Locale.ROOT).contains(FeatureFlagEvaluator.valueAsString(propertyValue).toLowerCase(Locale.ROOT)));
            }
            case "not_icontains" -> {
                FeatureFlagState var6_12;
                yield var6_12 = new FeatureFlagState(!FeatureFlagEvaluator.valueAsString(personValue).toLowerCase(Locale.ROOT).contains(FeatureFlagEvaluator.valueAsString(propertyValue).toLowerCase(Locale.ROOT)));
            }
            case "regex" -> {
                try {
                    FeatureFlagState var6_13;
                    yield var6_13 = new FeatureFlagState(FeatureFlagEvaluator.valueAsString(personValue).matches(FeatureFlagEvaluator.valueAsString(propertyValue)));
                }
                catch (PatternSyntaxException ignored) {
                    FeatureFlagState var6_14;
                    yield var6_14 = FeatureFlagState.DISABLED;
                }
            }
            case "not_regex" -> {
                try {
                    FeatureFlagState var6_15;
                    yield var6_15 = new FeatureFlagState(!FeatureFlagEvaluator.valueAsString(personValue).matches(FeatureFlagEvaluator.valueAsString(propertyValue)));
                }
                catch (PatternSyntaxException ignored) {
                    FeatureFlagState var6_16;
                    yield var6_16 = FeatureFlagState.DISABLED;
                }
            }
            case "gt" -> {
                FeatureFlagState var6_17;
                yield var6_17 = new FeatureFlagState(FeatureFlagEvaluator.valueAsNumber(personValue).doubleValue() > FeatureFlagEvaluator.valueAsNumber(propertyValue).doubleValue());
            }
            case "lt" -> {
                FeatureFlagState var6_18;
                yield var6_18 = new FeatureFlagState(FeatureFlagEvaluator.valueAsNumber(personValue).doubleValue() < FeatureFlagEvaluator.valueAsNumber(propertyValue).doubleValue());
            }
            case "gte" -> {
                FeatureFlagState var6_19;
                yield var6_19 = new FeatureFlagState(FeatureFlagEvaluator.valueAsNumber(personValue).doubleValue() >= FeatureFlagEvaluator.valueAsNumber(propertyValue).doubleValue());
            }
            case "lte" -> {
                FeatureFlagState var6_20;
                yield var6_20 = new FeatureFlagState(FeatureFlagEvaluator.valueAsNumber(personValue).doubleValue() <= FeatureFlagEvaluator.valueAsNumber(propertyValue).doubleValue());
            }
            default -> {
                FeatureFlagState var6_21;
                yield var6_21 = new FeatureFlagState(false, null, "Unknown operator: " + property.operator());
            }
        };
    }

    @NotNull
    private static FeatureFlagState getMatchingVariant(@NotNull FeatureFlagsResponse.Flag flag, @NotNull String distinctId) {
        FeatureFlagsResponse.Variants multivariates = flag.filters().multivariate();
        if (multivariates == null || multivariates.variants() == null) {
            return FeatureFlagState.ENABLED;
        }
        double value = FeatureFlagEvaluator.hash(flag.key(), distinctId, "variant");
        double valueMin = 0.0;
        for (FeatureFlagsResponse.Variant variant : multivariates.variants()) {
            if (variant.rolloutPercentage() == null) continue;
            double valueMax = valueMin + (double)variant.rolloutPercentage().intValue() / 100.0;
            if (value >= valueMin && value < valueMax) {
                return new FeatureFlagState(true, variant.key(), null);
            }
            valueMin = valueMax;
        }
        return FeatureFlagState.ENABLED;
    }

    private static boolean containsVariant(@NotNull FeatureFlagsResponse.Variants variants, @NotNull String variant) {
        if (variants.variants() == null || variants.variants().isEmpty()) {
            return false;
        }
        for (FeatureFlagsResponse.Variant v : variants.variants()) {
            if (!v.key().equals(variant)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static FeatureFlagState checkIfSimpleFlagEnabled(@NotNull String key, @NotNull String distinctId, int rolloutPercentage) {
        return FeatureFlagEvaluator.hash(key, distinctId, "") <= (double)rolloutPercentage / 100.0 ? FeatureFlagState.ENABLED : FeatureFlagState.DISABLED;
    }

    private static double hash(@NotNull String key, @NotNull String distinctId, @NotNull String salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update((key + "." + distinctId + salt).getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                sb.append(String.format("%02x", b));
            }
            String hexString = sb.substring(0, Math.min(15, sb.length()));
            return (double)Long.parseLong(hexString, 16) / 1.152921504606847E18;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean contains(@NotNull JsonArray array, @NotNull JsonElement elem) {
        for (JsonElement e : array) {
            if (!e.equals(elem)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String valueAsString(@NotNull JsonElement elem) {
        if (elem.isJsonPrimitive()) {
            return elem.getAsString();
        }
        if (elem.isJsonNull()) {
            return "null";
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(elem) + " to string");
    }

    @NotNull
    private static Number valueAsNumber(@NotNull JsonElement elem) {
        if (elem.isJsonPrimitive()) {
            return elem.getAsNumber();
        }
        if (elem.isJsonNull()) {
            return 0;
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(elem) + " to number");
    }

    private FeatureFlagEvaluator() {
    }
}

