/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.posthog;

import java.time.Duration;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;

final class Timer {
    private final Runnable task;
    private final long maxFlushIntervalNs;
    private final Thread taskThread;
    private volatile boolean closed = false;

    public Timer(@NotNull Runnable task, @NotNull Duration flushInterval) {
        this.task = task;
        this.maxFlushIntervalNs = flushInterval.toNanos();
        this.taskThread = Thread.startVirtualThread(this::runLoop);
    }

    public void wakeup() {
        this.checkNotClosed();
        LockSupport.unpark(this.taskThread);
    }

    public void close() {
        this.checkNotClosed();
        this.closed = true;
        LockSupport.unpark(this.taskThread);
    }

    private void runLoop() {
        while (!this.closed) {
            this.task.run();
            LockSupport.parkNanos(this.maxFlushIntervalNs);
        }
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Event queue has been closed");
        }
    }
}

