/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.posthog;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class EventQueue {
    private final ConcurrentLinkedQueue<JsonObject> queue = new ConcurrentLinkedQueue();
    private final AtomicInteger count = new AtomicInteger(0);
    private final Consumer<JsonArray> batchProcessor;
    private final long maxFlushIntervalNs;
    private final int batchSize;
    private final Thread consumerThread;
    private volatile boolean closed = false;

    public EventQueue(@NotNull Consumer<JsonArray> batchProcessor, @NotNull Duration maxFlushInterval, int batchSize) {
        this.batchProcessor = batchProcessor;
        this.maxFlushIntervalNs = maxFlushInterval.toNanos();
        this.batchSize = batchSize;
        this.consumerThread = Thread.startVirtualThread(this::consumeLoop);
    }

    public void enqueue(@NotNull JsonObject event) {
        this.checkNotClosed();
        this.queue.add(event);
        if (this.count.incrementAndGet() >= this.batchSize) {
            LockSupport.unpark(this.consumerThread);
        }
    }

    public void flush() {
        this.checkNotClosed();
        LockSupport.unpark(this.consumerThread);
    }

    public void close(@NotNull Duration timeout) {
        this.checkNotClosed();
        this.closed = true;
        LockSupport.unpark(this.consumerThread);
        try {
            this.consumerThread.join(Math.max(0L, timeout.toMillis()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void consumeLoop() {
        do {
            LockSupport.parkNanos(this.maxFlushIntervalNs);
            int toProcess = this.count.getAndSet(0);
            if (toProcess == 0) continue;
            while (toProcess > 0) {
                JsonObject event;
                JsonArray batch = new JsonArray(toProcess);
                for (int i = 0; i < this.batchSize && toProcess > 0 && (event = this.queue.poll()) != null; --toProcess, ++i) {
                    batch.add((JsonElement)event);
                }
                this.batchProcessor.accept(batch);
            }
        } while (!this.closed);
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Event queue has been closed");
        }
    }
}

