/*
 * Decompiled with CFR 0.152.
 */
package net.hollowcube.posthog;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.hollowcube.posthog.FeatureFlagContext;
import net.hollowcube.posthog.FeatureFlagState;
import net.hollowcube.posthog.FeatureFlagStates;
import net.hollowcube.posthog.PostHogClient;
import net.hollowcube.posthog.PostHogClientNoop;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostHog {
    private static PostHogClient client = PostHogClientNoop.INSTANCE;

    public static void init(@NotNull String projectApiKey) {
        PostHog.init(projectApiKey, Function.identity());
    }

    public static void init(@NotNull String projectApiKey, @NotNull Function<PostHogClient.Builder, PostHogClient.Builder> builderFunc) {
        if (client != PostHogClientNoop.INSTANCE) {
            throw new IllegalStateException("PostHog client already initialized");
        }
        client = builderFunc.apply(PostHogClient.newBuilder(projectApiKey)).build();
    }

    @NotNull
    public static PostHogClient getClient() {
        return Objects.requireNonNull(client, "PostHog client not initialized");
    }

    @Blocking
    public static void shutdown() {
        PostHog.shutdown(Duration.ofSeconds(10L));
    }

    @Blocking
    public static void shutdown(@NotNull Duration timeout) {
        PostHog.getClient().shutdown(timeout);
    }

    public static void capture(@NotNull String distinctId, @NotNull String event) {
        PostHog.getClient().capture(distinctId, event);
    }

    public static void capture(@NotNull String distinctId, @NotNull String event, @NotNull Map<String, Object> properties) {
        PostHog.getClient().capture(distinctId, event, properties);
    }

    public static void capture(@NotNull String distinctId, @NotNull String event, @NotNull Object properties) {
        PostHog.getClient().capture(distinctId, event, properties);
    }

    public static void identify(@NotNull String distinctId, @Nullable Map<String, Object> properties, @Nullable Map<String, Object> propertiesSetOnce) {
        PostHog.getClient().identify(distinctId, properties, propertiesSetOnce);
    }

    public static void identify(@NotNull String distinctId, @Nullable Object properties, @Nullable Object propertiesSetOnce) {
        PostHog.getClient().identify(distinctId, properties, propertiesSetOnce);
    }

    public static void identify(@NotNull String distinctId, @Nullable Map<String, Object> properties) {
        PostHog.getClient().identify(distinctId, properties);
    }

    public static void identify(@NotNull String distinctId, @Nullable Object properties) {
        PostHog.getClient().identify(distinctId, properties);
    }

    public static void alias(@NotNull String distinctId, @NotNull String alias) {
        PostHog.getClient().alias(distinctId, alias);
    }

    public static void groupIdentify(@NotNull String type, @NotNull String key, @NotNull Map<String, Object> properties) {
        PostHog.getClient().groupIdentify(type, key, properties);
    }

    public static void groupIdentify(@NotNull String type, @NotNull String key, @NotNull Object properties) {
        PostHog.getClient().groupIdentify(type, key, properties);
    }

    public static void flush() {
        PostHog.getClient().flush();
    }

    public static boolean isFeatureEnabled(@NotNull String key, @NotNull String distinctId) {
        return PostHog.getClient().isFeatureEnabled(key, distinctId);
    }

    public static boolean isFeatureEnabled(@NotNull String key, @NotNull String distinctId, @Nullable FeatureFlagContext context) {
        return PostHog.getClient().isFeatureEnabled(key, distinctId, context);
    }

    @NotNull
    public static FeatureFlagState getFeatureFlag(@NotNull String key, @NotNull String distinctId) {
        return PostHog.getClient().getFeatureFlag(key, distinctId);
    }

    @NotNull
    public static FeatureFlagState getFeatureFlag(@NotNull String key, @NotNull String distinctId, @Nullable FeatureFlagContext context) {
        return PostHog.getClient().getFeatureFlag(key, distinctId, context);
    }

    @NotNull
    public static FeatureFlagStates getAllFeatureFlags(@NotNull String distinctId) {
        return PostHog.getClient().getAllFeatureFlags(distinctId);
    }

    @NotNull
    public static FeatureFlagStates getAllFeatureFlags(@NotNull String distinctId, @Nullable FeatureFlagContext context) {
        return PostHog.getClient().getAllFeatureFlags(distinctId, context);
    }

    public static void reloadFeatureFlags() {
        PostHog.getClient().reloadFeatureFlags();
    }

    public static void captureException(@NotNull Throwable throwable) {
        PostHog.getClient().captureException(throwable);
    }

    public static void captureException(@NotNull Throwable throwable, @NotNull String distinctId) {
        PostHog.getClient().captureException(throwable, distinctId);
    }

    public static void captureException(@NotNull Throwable throwable, @NotNull String distinctId, @NotNull Map<String, Object> properties) {
        PostHog.getClient().captureException(throwable, distinctId, properties);
    }

    public static void captureException(@NotNull Throwable throwable, @Nullable String distinctId, @Nullable Object properties) {
        PostHog.getClient().captureException(throwable, distinctId, properties);
    }
}

