/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.ErrorResponse$BadRequest$;
import dev.hnaderi.k8s.client.ErrorResponse$Conflict$;
import dev.hnaderi.k8s.client.ErrorResponse$NotFound$;
import dev.hnaderi.k8s.client.ErrorResponse$Unauthorized$;
import dev.hnaderi.k8s.client.HttpClient;
import dev.hnaderi.k8s.client.PatchType;
import dev.hnaderi.k8s.client.ZIOKubernetesClient$;
import dev.hnaderi.k8s.client.ZIOKubernetesClient$DecodeError$;
import dev.hnaderi.k8s.utils.Decoder;
import dev.hnaderi.k8s.utils.Encoder;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zhttp.http.Headers;
import zhttp.http.Headers$;
import zhttp.http.HttpData;
import zhttp.http.HttpData$;
import zhttp.http.Method;
import zhttp.http.Request;
import zhttp.http.Request$;
import zhttp.http.Response;
import zhttp.http.Status;
import zhttp.http.URL;
import zhttp.http.URL$;
import zhttp.http.Version;
import zhttp.service.Client;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.json.JsonDecoder$;
import zio.json.package;

public final class ZIOKubernetesClient
implements HttpClient<ZIO<Object, Throwable, Object>>,
Product,
Serializable {
    private final String serverUrl;
    private final Client client;

    public static ZIOKubernetesClient apply(String string, Client<Object> client) {
        return ZIOKubernetesClient$.MODULE$.apply(string, client);
    }

    public static ZIOKubernetesClient fromProduct(Product product) {
        return ZIOKubernetesClient$.MODULE$.fromProduct(product);
    }

    public static ZLayer<Object, Nothing$, ZIOKubernetesClient> make(String string) {
        return ZIOKubernetesClient$.MODULE$.make(string);
    }

    public static ZIOKubernetesClient unapply(ZIOKubernetesClient zIOKubernetesClient) {
        return ZIOKubernetesClient$.MODULE$.unapply(zIOKubernetesClient);
    }

    public ZIOKubernetesClient(String serverUrl, Client<Object> client) {
        this.serverUrl = serverUrl;
        this.client = client;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ZIOKubernetesClient)) return false;
        ZIOKubernetesClient zIOKubernetesClient = (ZIOKubernetesClient)object;
        String string = this.serverUrl();
        String string2 = zIOKubernetesClient.serverUrl();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Client<Object> client = this.client();
        Client<Object> client2 = zIOKubernetesClient.client();
        if (client == null) {
            if (client2 == null) return true;
            return false;
        } else {
            if (!client.equals(client2)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ZIOKubernetesClient;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ZIOKubernetesClient";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "serverUrl";
        }
        if (1 == n2) {
            return "client";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String serverUrl() {
        return this.serverUrl;
    }

    public Client<Object> client() {
        return this.client;
    }

    private ZIO<Object, Throwable, URL> urlFor(String url, Seq<Tuple2<String, String>> params) {
        return ZIO$.MODULE$.fromEither(() -> this.urlFor$$anonfun$1(url), (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.urlFor(ZIOKubernetesClient.scala:42)").map((Function1 & Serializable)u -> {
            Map qp = (Map)params.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Map qs = (Map)tuple2._1();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        Option option = qs.get((Object)k);
                        if (None$.MODULE$.equals(option)) {
                            return (Map)qs.updated((Object)k, package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{v})));
                        }
                        if (option instanceof Some) {
                            List value = (List)((Some)option).value();
                            return (Map)qs.updated((Object)k, (Object)value.$colon$colon((Object)v));
                        }
                        throw new MatchError((Object)option);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return Tuple2$.MODULE$.apply(u, (Object)qp);
        }, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.urlFor(ZIOKubernetesClient.scala:48)").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                URL u = (URL)tuple2._1();
                Map qp = (Map)tuple2._2();
                return u.setQueryParams(qp);
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.urlFor(ZIOKubernetesClient.scala:49)");
    }

    private <O> ZIO<Object, Throwable, O> expect(Request req, Decoder<O> evidence$1) {
        return this.client().request(req, Client.Config$.MODULE$.empty()).flatMap((Function1 & Serializable)res -> {
            Status status = res.status();
            Status s = status;
            if (s.isSuccess()) {
                return ZIOKubernetesClient.readBody$1(evidence$1, res);
            }
            if (Status.Conflict$.MODULE$.equals(status)) {
                return ZIO$.MODULE$.die(ZIOKubernetesClient::expect$$anonfun$1$$anonfun$1, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect(ZIOKubernetesClient.scala:64)");
            }
            if (Status.BadRequest$.MODULE$.equals(status)) {
                return ZIO$.MODULE$.die(ZIOKubernetesClient::expect$$anonfun$1$$anonfun$2, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect(ZIOKubernetesClient.scala:65)");
            }
            if (Status.Unauthorized$.MODULE$.equals(status)) {
                return ZIO$.MODULE$.die(ZIOKubernetesClient::expect$$anonfun$1$$anonfun$3, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect(ZIOKubernetesClient.scala:66)");
            }
            if (Status.NotFound$.MODULE$.equals(status)) {
                return ZIO$.MODULE$.die(ZIOKubernetesClient::expect$$anonfun$1$$anonfun$4, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect(ZIOKubernetesClient.scala:67)");
            }
            Status s2 = status;
            return ZIO$.MODULE$.die(() -> ZIOKubernetesClient.expect$$anonfun$1$$anonfun$5(s2), (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect(ZIOKubernetesClient.scala:68)");
        }, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect(ZIOKubernetesClient.scala:70)");
    }

    private <I, O> ZIO<Object, Throwable, O> send(String url, Seq<Tuple2<String, String>> params, Method method, Option<I> body, String contentType, Encoder<I> evidence$2, Decoder<O> evidence$3) {
        return this.urlFor(url, params).map((Function1 & Serializable)u -> {
            HttpData httpData = (HttpData)body.fold(ZIOKubernetesClient::$anonfun$2, (Function1 & Serializable)b -> {
                Object object = zio.json.package$.MODULE$.EncoderOps(b);
                return HttpData$.MODULE$.fromString(package.EncoderOps$.MODULE$.toJson$extension(object, dev.hnaderi.k8s.zioJson.package$.MODULE$.zioEncoderFor(evidence$2)), HttpData$.MODULE$.fromString$default$2());
            });
            Headers headers = Headers$.MODULE$.contentType((CharSequence)contentType);
            Version version = Request$.MODULE$.apply$default$1();
            Request req = Request$.MODULE$.apply(version, method, u, headers, httpData);
            return Tuple2$.MODULE$.apply(u, (Object)req);
        }, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.send(ZIOKubernetesClient.scala:85)").flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                URL u = (URL)tuple2._1();
                Request req = (Request)tuple2._2();
                return this.expect(req, evidence$3).map((Function1 & Serializable)o -> o, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.send(ZIOKubernetesClient.scala:87)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.send(ZIOKubernetesClient.scala:87)");
    }

    private <I, O> String send$default$5() {
        return "application/json";
    }

    public <O> ZIO<Object, Throwable, O> get(String url, Seq<Tuple2<String, String>> params, Decoder<O> evidence$4) {
        return this.urlFor(url, params).map((Function1 & Serializable)u -> {
            Request req = Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), Request$.MODULE$.apply$default$2(), u, Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5());
            return Tuple2$.MODULE$.apply(u, (Object)req);
        }, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.get(ZIOKubernetesClient.scala:95)").flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                URL u = (URL)tuple2._1();
                Request req = (Request)tuple2._2();
                return this.expect(req, evidence$4).map((Function1 & Serializable)o -> o, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.get(ZIOKubernetesClient.scala:97)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.get(ZIOKubernetesClient.scala:97)");
    }

    public <I, O> ZIO<Object, Throwable, O> post(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$5, Decoder<O> evidence$6) {
        return this.send(url, params, (Method)Method.POST$.MODULE$, (Option<I>)Some$.MODULE$.apply(body), this.send$default$5(), evidence$5, evidence$6);
    }

    public <I, O> ZIO<Object, Throwable, O> put(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$7, Decoder<O> evidence$8) {
        return this.send(url, params, (Method)Method.PUT$.MODULE$, (Option<I>)Some$.MODULE$.apply(body), this.send$default$5(), evidence$7, evidence$8);
    }

    public <I, O> ZIO<Object, Throwable, O> patch(String url, PatchType patch, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$9, Decoder<O> evidence$10) {
        return this.send(url, params, (Method)Method.PATCH$.MODULE$, (Option<I>)Some$.MODULE$.apply(body), patch.contentType(), evidence$9, evidence$10);
    }

    public <I, O> ZIO<Object, Throwable, O> delete(String url, Seq<Tuple2<String, String>> params, Option<I> body, Encoder<I> evidence$11, Decoder<O> evidence$12) {
        return this.send(url, params, (Method)Method.DELETE$.MODULE$, body, this.send$default$5(), evidence$11, evidence$12);
    }

    public ZIOKubernetesClient copy(String serverUrl, Client<Object> client) {
        return new ZIOKubernetesClient(serverUrl, client);
    }

    public String copy$default$1() {
        return this.serverUrl();
    }

    public Client<Object> copy$default$2() {
        return this.client();
    }

    public String _1() {
        return this.serverUrl();
    }

    public Client<Object> _2() {
        return this.client();
    }

    private final Either urlFor$$anonfun$1(String url$1) {
        return URL$.MODULE$.fromString(new StringBuilder(0).append(this.serverUrl()).append(url$1).toString());
    }

    private static final Either readBody$1$$anonfun$1$$anonfun$1(Decoder evidence$1$4, String body$1) {
        return JsonDecoder$.MODULE$.apply(dev.hnaderi.k8s.zioJson.package$.MODULE$.zioDecoderFor(evidence$1$4)).decodeJson((CharSequence)body$1).left().map((Function1 & Serializable)_$1 -> ZIOKubernetesClient$DecodeError$.MODULE$.apply((String)_$1));
    }

    private static final ZIO readBody$1(Decoder evidence$1$1, Response res$1) {
        return res$1.bodyAsString().flatMap((Function1 & Serializable)body -> ZIO$.MODULE$.fromEither(() -> ZIOKubernetesClient.readBody$1$$anonfun$1$$anonfun$1(evidence$1$1, body), (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect.readBody(ZIOKubernetesClient.scala:59)"), (Object)"dev.hnaderi.k8s.client.ZIOKubernetesClient.expect.readBody(ZIOKubernetesClient.scala:60)");
    }

    private static final ErrorResponse$Conflict$ expect$$anonfun$1$$anonfun$1() {
        return ErrorResponse$Conflict$.MODULE$;
    }

    private static final ErrorResponse$BadRequest$ expect$$anonfun$1$$anonfun$2() {
        return ErrorResponse$BadRequest$.MODULE$;
    }

    private static final ErrorResponse$Unauthorized$ expect$$anonfun$1$$anonfun$3() {
        return ErrorResponse$Unauthorized$.MODULE$;
    }

    private static final ErrorResponse$NotFound$ expect$$anonfun$1$$anonfun$4() {
        return ErrorResponse$NotFound$.MODULE$;
    }

    private static final Exception expect$$anonfun$1$$anonfun$5(Status s$1) {
        return new Exception(new StringBuilder(14).append("General error ").append(s$1).toString());
    }

    private static final HttpData $anonfun$2() {
        return HttpData$.MODULE$.empty();
    }

    public static final class DecodeError
    extends Exception
    implements Product {
        private final String msg;

        public static DecodeError apply(String string) {
            return ZIOKubernetesClient$DecodeError$.MODULE$.apply(string);
        }

        public static DecodeError fromProduct(Product product) {
            return ZIOKubernetesClient$DecodeError$.MODULE$.fromProduct(product);
        }

        public static DecodeError unapply(DecodeError decodeError) {
            return ZIOKubernetesClient$DecodeError$.MODULE$.unapply(decodeError);
        }

        public DecodeError(String msg) {
            this.msg = msg;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DecodeError)) return false;
            DecodeError decodeError = (DecodeError)object;
            String string = this.msg();
            String string2 = decodeError.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof DecodeError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DecodeError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public DecodeError copy(String msg) {
            return new DecodeError(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }
}

