/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.APIVerb;
import dev.hnaderi.k8s.client.ErrorResponse;
import dev.hnaderi.k8s.client.ErrorResponse$;
import dev.hnaderi.k8s.client.ErrorStatus;
import dev.hnaderi.k8s.client.HttpBackend;
import dev.hnaderi.k8s.client.PatchType;
import dev.hnaderi.k8s.client.ZIOBackend$;
import dev.hnaderi.k8s.client.ZIOBackend$DecodeError$;
import dev.hnaderi.k8s.utils.Decoder;
import dev.hnaderi.k8s.utils.Encoder;
import io.k8s.apimachinery.pkg.apis.meta.v1.Status$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Chunk;
import zio.Chunk$;
import zio.NonEmptyChunk$;
import zio.ZIO;
import zio.ZIO$;
import zio.ZLayer;
import zio.http.Body;
import zio.http.Body$;
import zio.http.Cookie;
import zio.http.Header;
import zio.http.Headers;
import zio.http.Headers$;
import zio.http.Method;
import zio.http.Request;
import zio.http.Request$;
import zio.http.Response;
import zio.http.Status;
import zio.http.URL;
import zio.http.URL$;
import zio.http.Version;
import zio.http.Version$;
import zio.http.ZClient;
import zio.json.JsonDecoder$;
import zio.json.package;
import zio.json.package$;

public final class ZIOBackend
implements HttpBackend<ZIO<Object, Throwable, Object>>,
Product,
Serializable {
    private final ZClient client;

    public static ZIOBackend apply(ZClient<Object, Body, Throwable, Response> zClient) {
        return ZIOBackend$.MODULE$.apply(zClient);
    }

    public static ZIOBackend fromProduct(Product product) {
        return ZIOBackend$.MODULE$.fromProduct(product);
    }

    public static ZLayer<ZClient<Object, Body, Throwable, Response>, Nothing$, ZIOBackend> make() {
        return ZIOBackend$.MODULE$.make();
    }

    public static ZIOBackend unapply(ZIOBackend zIOBackend) {
        return ZIOBackend$.MODULE$.unapply(zIOBackend);
    }

    public ZIOBackend(ZClient<Object, Body, Throwable, Response> client) {
        this.client = client;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ZIOBackend)) return false;
        ZIOBackend zIOBackend = (ZIOBackend)object;
        ZClient<Object, Body, Throwable, Response> zClient = this.client();
        ZClient<Object, Body, Throwable, Response> zClient2 = zIOBackend.client();
        if (zClient != null) {
            if (!zClient.equals(zClient2)) return false;
            return true;
        }
        if (zClient2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ZIOBackend;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "ZIOBackend";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "client";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ZClient<Object, Body, Throwable, Response> client() {
        return this.client;
    }

    public <O> ZIO<Object, Throwable, O> send(String url, APIVerb verb, Seq<Tuple2<String, String>> headers, Seq<Tuple2<String, String>> params, Seq<Tuple2<String, String>> cookies, Decoder<O> evidence$1) {
        return this.urlFor(url, params).flatMap((Function1 & Serializable)u -> this.contentType(verb).map((Function1 & Serializable)con -> {
            Method method = (Method)this.methodFor().apply((Object)verb);
            Body body = Body$.MODULE$.empty();
            Headers headers = Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{con})).$plus$plus(this.cookiesFor(cookies));
            Version version = Version$.MODULE$.HTTP$div1$u002E1();
            None$ none$ = None$.MODULE$;
            Request req = Request$.MODULE$.apply(version, method, u, headers, body, (Option)none$);
            return Tuple2$.MODULE$.apply(con, (Object)req);
        }, (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:50)").flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Header.ContentType con = (Header.ContentType)tuple2._1();
                Request req = (Request)tuple2._2();
                return this.expect(req, evidence$1).map((Function1 & Serializable)o -> o, (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:52)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:52)"), (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:52)");
    }

    public <I, O> ZIO<Object, Throwable, O> send(String url, APIVerb verb, I body, Seq<Tuple2<String, String>> headers, Seq<Tuple2<String, String>> params, Seq<Tuple2<String, String>> cookies, Encoder<I> evidence$1, Decoder<O> evidence$2) {
        return this.urlFor(url, params).flatMap((Function1 & Serializable)u -> this.contentType(verb).map((Function1 & Serializable)con -> {
            Method method = (Method)this.methodFor().apply((Object)verb);
            Object object = package$.MODULE$.EncoderOps(body);
            Body body = Body$.MODULE$.fromString(package.EncoderOps$.MODULE$.toJson$extension(object, dev.hnaderi.k8s.zioJson.package$.MODULE$.zioEncoderFor(evidence$1)), Body$.MODULE$.fromString$default$2());
            Headers headers = Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{con})).$plus$plus(this.cookiesFor(cookies));
            Version version = Version$.MODULE$.HTTP$div1$u002E1();
            None$ none$ = None$.MODULE$;
            Request req = Request$.MODULE$.apply(version, method, u, headers, body, (Option)none$);
            return Tuple2$.MODULE$.apply(con, (Object)req);
        }, (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:71)").flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Header.ContentType con = (Header.ContentType)tuple2._1();
                Request req = (Request)tuple2._2();
                return this.expect(req, evidence$2).map((Function1 & Serializable)o -> o, (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:73)");
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:73)"), (Object)"dev.hnaderi.k8s.client.ZIOBackend.send(ZIOBackend.scala:73)");
    }

    private Headers cookiesFor(Seq<Tuple2<String, String>> values) {
        return (Headers)NonEmptyChunk$.MODULE$.fromIterableOption((Iterable)values.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Cookie.Request$.MODULE$.apply(k, v);
            }
            throw new MatchError((Object)tuple2);
        })).map((Function1 & Serializable)_$1 -> Header.Cookie$.MODULE$.apply(_$1)).fold(ZIOBackend::cookiesFor$$anonfun$3, (Function1 & Serializable)_$2 -> Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header[]{_$2})));
    }

    private Function1<APIVerb, Method> methodFor() {
        return (Function1 & Serializable)x$1 -> {
            APIVerb aPIVerb = x$1;
            if (APIVerb.GET$.MODULE$.equals(aPIVerb)) {
                return Method.GET$.MODULE$;
            }
            if (APIVerb.POST$.MODULE$.equals(aPIVerb)) {
                return Method.POST$.MODULE$;
            }
            if (APIVerb.DELETE$.MODULE$.equals(aPIVerb)) {
                return Method.DELETE$.MODULE$;
            }
            if (APIVerb.PUT$.MODULE$.equals(aPIVerb)) {
                return Method.PUT$.MODULE$;
            }
            if (aPIVerb instanceof APIVerb.PATCH) {
                APIVerb.PATCH pATCH = APIVerb.PATCH$.MODULE$.unapply((APIVerb.PATCH)aPIVerb);
                PatchType patchType = pATCH._1();
                return Method.PATCH$.MODULE$;
            }
            throw new MatchError((Object)aPIVerb);
        };
    }

    private ZIO<Object, IllegalArgumentException, Header.ContentType> contentType(APIVerb verb) {
        return ZIO$.MODULE$.fromEither(() -> ZIOBackend.contentType$$anonfun$1(verb), (Object)"dev.hnaderi.k8s.client.ZIOBackend.contentType(ZIOBackend.scala:101)");
    }

    private ZIO<Object, Throwable, URL> urlFor(String url, Seq<Tuple2<String, String>> params) {
        return ZIO$.MODULE$.fromEither(() -> ZIOBackend.urlFor$$anonfun$1(url), (Object)"dev.hnaderi.k8s.client.ZIOBackend.urlFor(ZIOBackend.scala:107)").map((Function1 & Serializable)u -> {
            Map qp = (Map)params.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Map qs = (Map)tuple2._1();
                    if (tuple22 != null) {
                        String k = (String)tuple22._1();
                        String v = (String)tuple22._2();
                        Option option = qs.get((Object)k);
                        if (None$.MODULE$.equals(option)) {
                            return (Map)qs.updated((Object)k, (Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{v})));
                        }
                        if (option instanceof Some) {
                            Chunk value = (Chunk)((Some)option).value();
                            return (Map)qs.updated((Object)k, (Object)Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{v})).$plus$plus(value));
                        }
                        throw new MatchError((Object)option);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return Tuple2$.MODULE$.apply(u, (Object)qp);
        }, (Object)"dev.hnaderi.k8s.client.ZIOBackend.urlFor(ZIOBackend.scala:114)").map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                URL u = (URL)tuple2._1();
                Map qp = (Map)tuple2._2();
                return u.queryParams(qp);
            }
            throw new MatchError((Object)tuple2);
        }, (Object)"dev.hnaderi.k8s.client.ZIOBackend.urlFor(ZIOBackend.scala:115)");
    }

    private <O> ZIO<Object, Throwable, O> expect(Request req, Decoder<O> evidence$1) {
        return this.client().request(req, (.less.colon.less)$less$colon$less$.MODULE$.refl(), (Object)"dev.hnaderi.k8s.client.ZIOBackend.expect(ZIOBackend.scala:118)").flatMap((Function1 & Serializable)res -> {
            ErrorStatus.Conflict$ conflict$;
            if (res.status().isSuccess()) {
                return ZIOBackend.readBody$1(res, evidence$1);
            }
            Status status = res.status();
            if (Status.Conflict$.MODULE$.equals(status)) {
                conflict$ = ErrorStatus.Conflict$.MODULE$;
            } else if (Status.BadRequest$.MODULE$.equals(status)) {
                conflict$ = ErrorStatus.BadRequest$.MODULE$;
            } else if (Status.Unauthorized$.MODULE$.equals(status)) {
                conflict$ = ErrorStatus.Unauthorized$.MODULE$;
            } else if (Status.NotFound$.MODULE$.equals(status)) {
                conflict$ = ErrorStatus.NotFound$.MODULE$;
            } else {
                Status s = status;
                conflict$ = ErrorStatus.Other$.MODULE$.apply(s.code());
            }
            ErrorStatus err = (ErrorStatus)conflict$;
            ZIO status2 = ZIOBackend.readBody$1(res, Status$.MODULE$.decoder());
            return status2.map((Function1 & Serializable)_$5 -> ErrorResponse$.MODULE$.apply(err, _$5), (Object)"dev.hnaderi.k8s.client.ZIOBackend.expect(ZIOBackend.scala:139)").flatMap((Function1 & Serializable)_$6 -> ZIO$.MODULE$.die(() -> ZIOBackend.expect$$anonfun$1$$anonfun$2$$anonfun$1(_$6), (Object)"dev.hnaderi.k8s.client.ZIOBackend.expect(ZIOBackend.scala:139)"), (Object)"dev.hnaderi.k8s.client.ZIOBackend.expect(ZIOBackend.scala:139)");
        }, (Object)"dev.hnaderi.k8s.client.ZIOBackend.expect(ZIOBackend.scala:141)");
    }

    public ZIOBackend copy(ZClient<Object, Body, Throwable, Response> client) {
        return new ZIOBackend(client);
    }

    public ZClient<Object, Body, Throwable, Response> copy$default$1() {
        return this.client();
    }

    public ZClient<Object, Body, Throwable, Response> _1() {
        return this.client();
    }

    private static final Headers cookiesFor$$anonfun$3() {
        return Headers$.MODULE$.empty();
    }

    private static final Either contentType$$anonfun$1(APIVerb verb$5) {
        String string;
        APIVerb aPIVerb = verb$5;
        if (aPIVerb instanceof APIVerb.PATCH) {
            PatchType patchType;
            APIVerb.PATCH pATCH = APIVerb.PATCH$.MODULE$.unapply((APIVerb.PATCH)aPIVerb);
            PatchType ptype = patchType = pATCH._1();
            string = ptype.contentType();
        } else {
            string = "application/json";
        }
        return Header.ContentType$.MODULE$.parse(string).left().map((Function1 & Serializable)_$3 -> new IllegalArgumentException((String)_$3));
    }

    private static final Either urlFor$$anonfun$1(String url$1) {
        return URL$.MODULE$.decode(url$1);
    }

    private static final Either readBody$1$$anonfun$1$$anonfun$1(Decoder evidence$1$6, String body$5) {
        return JsonDecoder$.MODULE$.apply(dev.hnaderi.k8s.zioJson.package$.MODULE$.zioDecoderFor(evidence$1$6)).decodeJson((CharSequence)body$5).left().map((Function1 & Serializable)_$4 -> ZIOBackend$DecodeError$.MODULE$.apply((String)_$4));
    }

    private static final ZIO readBody$1(Response res$1, Decoder evidence$1) {
        return res$1.body().asString((Object)"dev.hnaderi.k8s.client.ZIOBackend.expect.readBody(ZIOBackend.scala:120)").flatMap((Function1 & Serializable)body -> ZIO$.MODULE$.fromEither(() -> ZIOBackend.readBody$1$$anonfun$1$$anonfun$1(evidence$1, body), (Object)"dev.hnaderi.k8s.client.ZIOBackend.expect.readBody(ZIOBackend.scala:126)"), (Object)"dev.hnaderi.k8s.client.ZIOBackend.expect.readBody(ZIOBackend.scala:127)");
    }

    private static final Throwable expect$$anonfun$1$$anonfun$2$$anonfun$1(ErrorResponse _$6$1) {
        return _$6$1;
    }

    public static final class DecodeError
    extends Exception
    implements Product {
        private final String msg;

        public static DecodeError apply(String string) {
            return ZIOBackend$DecodeError$.MODULE$.apply(string);
        }

        public static DecodeError fromProduct(Product product) {
            return ZIOBackend$DecodeError$.MODULE$.fromProduct(product);
        }

        public static DecodeError unapply(DecodeError decodeError) {
            return ZIOBackend$DecodeError$.MODULE$.unapply(decodeError);
        }

        public DecodeError(String msg) {
            this.msg = msg;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DecodeError)) return false;
            DecodeError decodeError = (DecodeError)object;
            String string = this.msg();
            String string2 = decodeError.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof DecodeError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DecodeError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public DecodeError copy(String msg) {
            return new DecodeError(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }
}

