/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.APIVerb;
import dev.hnaderi.k8s.client.ErrorResponse$;
import dev.hnaderi.k8s.client.ErrorStatus;
import dev.hnaderi.k8s.client.HttpBackend;
import dev.hnaderi.k8s.client.PatchType;
import dev.hnaderi.k8s.client.SttpKBackend$;
import dev.hnaderi.k8s.client.SttpKBackend$DecodeError$;
import dev.hnaderi.k8s.client.SttpKBackend$InvalidURL$;
import dev.hnaderi.k8s.utils.Builder;
import dev.hnaderi.k8s.utils.Decoder;
import dev.hnaderi.k8s.utils.Encoder;
import dev.hnaderi.k8s.utils.Reader;
import dev.hnaderi.k8s.utils.package;
import io.k8s.apimachinery.pkg.apis.meta.v1.Status$;
import java.io.Serializable;
import org.typelevel.jawn.Facade;
import org.typelevel.jawn.Parser$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Either$;
import sttp.client3.BasicRequestBody;
import sttp.client3.ResponseAs;
import sttp.client3.ResponseAs$;
import sttp.client3.ResponseAsByteArray$;
import sttp.client3.SttpBackend;
import sttp.model.Header$;
import sttp.model.Method;
import sttp.model.Method$;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode$;
import sttp.model.Uri;
import sttp.model.Uri$;

public final class SttpKBackend<F, T>
implements HttpBackend<?> {
    private final SttpBackend<F, Object> client;
    private final Builder<T> evidence$1;
    private final Reader<T> evidence$2;
    private final Function1<T, BasicRequestBody> serializer;
    private final Facade.SimpleFacade<T> jawn;
    private final ResponseAs<Either<Throwable, T>, Object> ra;

    public static <F, T> SttpKBackend<F, T> apply(SttpBackend<F, Object> sttpBackend, Builder<T> builder, Reader<T> reader, Function1<T, BasicRequestBody> function1) {
        return SttpKBackend$.MODULE$.apply(sttpBackend, builder, reader, function1);
    }

    public SttpKBackend(SttpBackend<F, Object> client, Builder<T> evidence$1, Reader<T> evidence$2, Function1<T, BasicRequestBody> serializer) {
        this.client = client;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.serializer = serializer;
        this.jawn = dev.hnaderi.k8s.jawn.package$.MODULE$.jawnFacade(evidence$1);
        this.ra = ResponseAsByteArray$.MODULE$.mapWithMetadata((Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                byte[] b = (byte[])tuple2._1();
                ResponseMetadata resp = (ResponseMetadata)tuple2._2();
                Either body = Parser$.MODULE$.parseFromByteArray(b, this.jawn).toEither();
                if (StatusCode$.MODULE$.isSuccess$extension(resp.code())) {
                    return body;
                }
                Either either = Either$.MODULE$.MergeableEither(body.flatMap((Function1 & Serializable)_$3 -> {
                    Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(_$3);
                    return package.DecoderOps$.MODULE$.decodeTo$extension(object, Status$.MODULE$.decoder(), evidence$2).left().map((Function1 & Serializable)_$4 -> SttpKBackend$DecodeError$.MODULE$.apply((String)_$4));
                }).map((Function1 & Serializable)_$5 -> {
                    ErrorStatus.Conflict$ conflict$;
                    int n = resp.code();
                    if (StatusCode$.MODULE$.Conflict() == n) {
                        conflict$ = ErrorStatus.Conflict$.MODULE$;
                    } else if (StatusCode$.MODULE$.Unauthorized() == n) {
                        conflict$ = ErrorStatus.Unauthorized$.MODULE$;
                    } else if (StatusCode$.MODULE$.NotFound() == n) {
                        conflict$ = ErrorStatus.NotFound$.MODULE$;
                    } else if (StatusCode$.MODULE$.BadRequest() == n) {
                        conflict$ = ErrorStatus.BadRequest$.MODULE$;
                    } else {
                        int other = n;
                        conflict$ = ErrorStatus.Other$.MODULE$.apply(other);
                    }
                    return ErrorResponse$.MODULE$.apply((ErrorStatus)conflict$, _$5);
                }));
                return package$.MODULE$.Left().apply((Object)((Throwable)Either.MergeableEither$.MODULE$.merge$extension(either)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private <O> ResponseAs<O, Object> respAs(Decoder<O> evidence$1) {
        return ResponseAs$.MODULE$.RichResponseAsEither(this.ra.map((Function1 & Serializable)_$6 -> _$6.flatMap((Function1 & Serializable)_$7 -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(_$7);
            return package.DecoderOps$.MODULE$.decodeTo$extension(object, evidence$1, this.evidence$2).left().map((Function1 & Serializable)_$8 -> SttpKBackend$DecodeError$.MODULE$.apply((String)_$8));
        }))).getRight();
    }

    private Uri urlFor(String url, Seq<Tuple2<String, String>> params) {
        return ((Uri)Uri$.MODULE$.parse(url).fold((Function1 & Serializable)err -> {
            throw SttpKBackend$InvalidURL$.MODULE$.apply((String)err);
        }, (Function1 & Serializable)x -> (Uri)Predef$.MODULE$.identity(x))).addParams(params);
    }

    private String methodFor(APIVerb verb) {
        Method method;
        APIVerb aPIVerb = verb;
        if (APIVerb.GET$.MODULE$.equals(aPIVerb)) {
            method = new Method(Method$.MODULE$.GET());
        } else if (APIVerb.POST$.MODULE$.equals(aPIVerb)) {
            method = new Method(Method$.MODULE$.POST());
        } else if (APIVerb.DELETE$.MODULE$.equals(aPIVerb)) {
            method = new Method(Method$.MODULE$.DELETE());
        } else if (APIVerb.PUT$.MODULE$.equals(aPIVerb)) {
            method = new Method(Method$.MODULE$.PUT());
        } else if (aPIVerb instanceof APIVerb.PATCH) {
            APIVerb.PATCH pATCH = APIVerb.PATCH$.MODULE$.unapply((APIVerb.PATCH)aPIVerb);
            PatchType patchType = pATCH._1();
            method = new Method(Method$.MODULE$.PATCH());
        } else {
            throw new MatchError((Object)aPIVerb);
        }
        Method method2 = method;
        if (method2 == null) {
            return null;
        }
        return method2.method();
    }

    public <O> F send(String url, APIVerb verb, Seq<Tuple2<String, String>> headers, Seq<Tuple2<String, String>> params, Seq<Tuple2<String, String>> cookies, Decoder<O> evidence$1) {
        return (F)sttp.client3.package$.MODULE$.basicRequest().method(this.methodFor(verb), this.urlFor(url, params)).headers((Seq)headers.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Header$.MODULE$.apply(k, v);
            }
            throw new MatchError((Object)tuple2);
        })).cookies(cookies).response(this.respAs(evidence$1)).send(this.client, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <I, O> F send(String url, APIVerb verb, I body, Seq<Tuple2<String, String>> headers, Seq<Tuple2<String, String>> params, Seq<Tuple2<String, String>> cookies, Encoder<I> evidence$1, Decoder<O> evidence$2) {
        Object object = dev.hnaderi.k8s.utils.package$.MODULE$.EncoderOps(body);
        return (F)sttp.client3.package$.MODULE$.basicRequest().method(this.methodFor(verb), this.urlFor(url, params)).body(package.EncoderOps$.MODULE$.encodeTo$extension(object, evidence$1, this.evidence$1), this.serializer).headers((Seq)headers.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return Header$.MODULE$.apply(k, v);
            }
            throw new MatchError((Object)tuple2);
        })).cookies(cookies).response(this.respAs(evidence$2)).send(this.client, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final class DecodeError
    extends Exception
    implements Product {
        private final String msg;

        public static DecodeError apply(String string) {
            return SttpKBackend$DecodeError$.MODULE$.apply(string);
        }

        public static DecodeError fromProduct(Product product) {
            return SttpKBackend$DecodeError$.MODULE$.fromProduct(product);
        }

        public static DecodeError unapply(DecodeError decodeError) {
            return SttpKBackend$DecodeError$.MODULE$.unapply(decodeError);
        }

        public DecodeError(String msg) {
            this.msg = msg;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DecodeError)) return false;
            DecodeError decodeError = (DecodeError)object;
            String string = this.msg();
            String string2 = decodeError.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof DecodeError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DecodeError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public DecodeError copy(String msg) {
            return new DecodeError(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class InvalidURL
    extends Exception
    implements Product {
        private final String msg;

        public static InvalidURL apply(String string) {
            return SttpKBackend$InvalidURL$.MODULE$.apply(string);
        }

        public static InvalidURL fromProduct(Product product) {
            return SttpKBackend$InvalidURL$.MODULE$.fromProduct(product);
        }

        public static InvalidURL unapply(InvalidURL invalidURL) {
            return SttpKBackend$InvalidURL$.MODULE$.unapply(invalidURL);
        }

        public InvalidURL(String msg) {
            this.msg = msg;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidURL)) return false;
            InvalidURL invalidURL = (InvalidURL)object;
            String string = this.msg();
            String string2 = invalidURL.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidURL;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InvalidURL";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public InvalidURL copy(String msg) {
            return new InvalidURL(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }
}

