/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.HttpClient;
import dev.hnaderi.k8s.client.SttpKubernetesClient$DecodeError$;
import dev.hnaderi.k8s.client.SttpKubernetesClient$InvalidURL$;
import dev.hnaderi.k8s.jawn.package$;
import dev.hnaderi.k8s.utils.Builder;
import dev.hnaderi.k8s.utils.Decoder;
import dev.hnaderi.k8s.utils.Encoder;
import dev.hnaderi.k8s.utils.Reader;
import dev.hnaderi.k8s.utils.package;
import java.io.Serializable;
import org.typelevel.jawn.Facade;
import org.typelevel.jawn.Parser$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sttp.client3.BasicRequestBody;
import sttp.client3.ResponseAs;
import sttp.client3.ResponseAs$;
import sttp.client3.ResponseAsByteArray$;
import sttp.client3.SttpBackend;
import sttp.model.Uri;
import sttp.model.Uri$;

public final class SttpKubernetesClient<F, T>
implements HttpClient<?> {
    private final String serverUrl;
    private final SttpBackend<F, Object> client;
    private final Builder<T> evidence$1;
    private final Reader<T> evidence$2;
    private final Function1<T, BasicRequestBody> serializer;
    private final Facade.SimpleFacade<T> jawn;
    private final ResponseAs<Either<Throwable, T>, Object> ra;

    public SttpKubernetesClient(String serverUrl, SttpBackend<F, Object> client, Builder<T> evidence$1, Reader<T> evidence$2, Function1<T, BasicRequestBody> serializer) {
        this.serverUrl = serverUrl;
        this.client = client;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        this.serializer = serializer;
        this.jawn = package$.MODULE$.jawnFacade(evidence$1);
        this.ra = ResponseAsByteArray$.MODULE$.map((Function1 & Serializable)_$3 -> Parser$.MODULE$.parseFromByteArray(_$3, this.jawn).toEither());
    }

    private <O> ResponseAs<O, Object> respAs(Decoder<O> evidence$3) {
        return ResponseAs$.MODULE$.RichResponseAsEither(this.ra.map((Function1 & Serializable)_$4 -> _$4.flatMap((Function1 & Serializable)_$5 -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.DecoderOps(_$5);
            return package.DecoderOps$.MODULE$.decodeTo$extension(object, evidence$3, this.evidence$2).left().map((Function1 & Serializable)_$6 -> SttpKubernetesClient$DecodeError$.MODULE$.apply((String)_$6));
        }))).getRight();
    }

    private Uri urlFor(String url, Seq<Tuple2<String, String>> params) {
        return ((Uri)Uri$.MODULE$.parse(new StringBuilder(0).append(this.serverUrl).append(url).toString()).fold((Function1 & Serializable)err -> {
            throw SttpKubernetesClient$InvalidURL$.MODULE$.apply((String)err);
        }, (Function1 & Serializable)x -> (Uri)Predef$.MODULE$.identity(x))).addParams(params);
    }

    private <O> Function1<O, BasicRequestBody> bodyEncoder(Encoder<O> evidence$4) {
        return this.serializer.compose((Function1 & Serializable)_$7 -> {
            Object object = dev.hnaderi.k8s.utils.package$.MODULE$.EncoderOps(_$7);
            return package.EncoderOps$.MODULE$.encodeTo$extension(object, evidence$4, this.evidence$1);
        });
    }

    public <O> F get(String url, Seq<Tuple2<String, String>> params, Decoder<O> evidence$5) {
        return (F)sttp.client3.package$.MODULE$.basicRequest().get(this.urlFor(url, params)).response(this.respAs(evidence$5)).send(this.client, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <I, O> F post(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$6, Decoder<O> evidence$7) {
        return (F)sttp.client3.package$.MODULE$.basicRequest().post(this.urlFor(url, params)).body(body, this.bodyEncoder(evidence$6)).response(this.respAs(evidence$7)).send(this.client, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <I, O> F put(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$8, Decoder<O> evidence$9) {
        return (F)sttp.client3.package$.MODULE$.basicRequest().put(this.urlFor(url, params)).body(body, this.bodyEncoder(evidence$8)).response(this.respAs(evidence$9)).send(this.client, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <I, O> F patch(String url, Seq<Tuple2<String, String>> params, I body, Encoder<I> evidence$10, Decoder<O> evidence$11) {
        return (F)sttp.client3.package$.MODULE$.basicRequest().patch(this.urlFor(url, params)).body(body, this.bodyEncoder(evidence$10)).response(this.respAs(evidence$11)).send(this.client, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <O> F delete(String url, Seq<Tuple2<String, String>> params, Decoder<O> evidence$12) {
        return (F)sttp.client3.package$.MODULE$.basicRequest().delete(this.urlFor(url, params)).response(this.respAs(evidence$12)).send(this.client, $less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final class DecodeError
    extends Exception
    implements Product {
        private final String msg;

        public static DecodeError apply(String string) {
            return SttpKubernetesClient$DecodeError$.MODULE$.apply(string);
        }

        public static DecodeError fromProduct(Product product) {
            return SttpKubernetesClient$DecodeError$.MODULE$.fromProduct(product);
        }

        public static DecodeError unapply(DecodeError decodeError) {
            return SttpKubernetesClient$DecodeError$.MODULE$.unapply(decodeError);
        }

        public DecodeError(String msg) {
            this.msg = msg;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DecodeError)) return false;
            DecodeError decodeError = (DecodeError)object;
            String string = this.msg();
            String string2 = decodeError.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof DecodeError;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DecodeError";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public DecodeError copy(String msg) {
            return new DecodeError(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }

    public static final class InvalidURL
    extends Exception
    implements Product {
        private final String msg;

        public static InvalidURL apply(String string) {
            return SttpKubernetesClient$InvalidURL$.MODULE$.apply(string);
        }

        public static InvalidURL fromProduct(Product product) {
            return SttpKubernetesClient$InvalidURL$.MODULE$.fromProduct(product);
        }

        public static InvalidURL unapply(InvalidURL invalidURL) {
            return SttpKubernetesClient$InvalidURL$.MODULE$.unapply(invalidURL);
        }

        public InvalidURL(String msg) {
            this.msg = msg;
            super(msg);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InvalidURL)) return false;
            InvalidURL invalidURL = (InvalidURL)object;
            String string = this.msg();
            String string2 = invalidURL.msg();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof InvalidURL;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "InvalidURL";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String msg() {
            return this.msg;
        }

        public InvalidURL copy(String msg) {
            return new InvalidURL(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String _1() {
            return this.msg();
        }
    }
}

