/*
 * Decompiled with CFR 0.152.
 */
package dev.hnaderi.k8s.client;

import dev.hnaderi.k8s.client.AuthInfo;
import dev.hnaderi.k8s.client.AuthenticationParams;
import dev.hnaderi.k8s.client.AuthenticationParams$;
import dev.hnaderi.k8s.client.Cluster;
import dev.hnaderi.k8s.client.Config;
import dev.hnaderi.k8s.client.Config$;
import dev.hnaderi.k8s.client.Conversions$;
import dev.hnaderi.k8s.client.HttpClient;
import dev.hnaderi.k8s.client.HttpClient$;
import dev.hnaderi.k8s.client.NamedContext;
import dev.hnaderi.k8s.client.SSLContexts$;
import dev.hnaderi.k8s.client.SttpKBackend$;
import dev.hnaderi.k8s.manifest.package$;
import dev.hnaderi.k8s.utils.Builder;
import dev.hnaderi.k8s.utils.Reader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.net.ssl.SSLContext;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sttp.client3.BasicRequestBody;
import sttp.client3.SttpBackend;

public interface SttpJVM<F> {
    public Function1<SSLContext, SttpBackend<F, Object>> buildWithSSLContext();

    public static HttpClient fromConfig$(SttpJVM $this, Config config, Option context, Option cluster, Builder evidence$1, Reader evidence$2, Function1 evidence$3) {
        return $this.fromConfig(config, (Option<String>)context, (Option<String>)cluster, evidence$1, evidence$2, evidence$3);
    }

    default public <T> HttpClient<?> fromConfig(Config config, Option<String> context, Option<String> cluster, Builder<T> evidence$1, Reader<T> evidence$2, Function1<T, BasicRequestBody> evidence$3) {
        Tuple3 tuple3;
        String currentContext = (String)context.getOrElse(() -> SttpJVM.$anonfun$1(config));
        Option toConnect = config.contexts().find((Function1 & Serializable)_$3 -> {
            String string = _$3.name();
            String string2 = currentContext;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)ctx -> {
            String clusterName = (String)cluster.getOrElse(() -> SttpJVM.$anonfun$4(ctx));
            return Tuple2$.MODULE$.apply(ctx, (Object)clusterName);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                NamedContext ctx = (NamedContext)tuple2._1();
                String clusterName = (String)tuple2._2();
                return config.clusters().find((Function1 & Serializable)_$4 -> {
                    String string = _$4.name();
                    String string2 = clusterName;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).flatMap((Function1 & Serializable)cluster -> config.users().find((Function1 & Serializable)_$5 -> {
                    String string = _$5.name();
                    String string2 = ctx.context().user();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }).map((Function1 & Serializable)user -> Tuple3$.MODULE$.apply((Object)cluster.cluster(), (Object)cluster.cluster().server(), (Object)user.user())));
            }
            throw new MatchError((Object)tuple2);
        });
        Option option = toConnect;
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Cannot find where/how to connect using the provided config!");
        }
        if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
            Cluster cluster2 = (Cluster)tuple3._1();
            String server = (String)tuple3._2();
            AuthInfo auth = (AuthInfo)tuple3._3();
            SSLContext ssl = SSLContexts$.MODULE$.from(cluster2, auth);
            return HttpClient$.MODULE$.apply(server, SttpKBackend$.MODULE$.apply((SttpBackend)this.buildWithSSLContext().apply((Object)ssl), evidence$1, evidence$2, evidence$3), AuthenticationParams$.MODULE$.from(auth));
        }
        throw new MatchError((Object)option);
    }

    public static Option fromConfig$default$2$(SttpJVM $this) {
        return $this.fromConfig$default$2();
    }

    default public <T> Option<String> fromConfig$default$2() {
        return None$.MODULE$;
    }

    public static Option fromConfig$default$3$(SttpJVM $this) {
        return $this.fromConfig$default$3();
    }

    default public <T> Option<String> fromConfig$default$3() {
        return None$.MODULE$;
    }

    public static HttpClient from$(SttpJVM $this, String server, Option ca, Option clientCert, Option clientKey, Option clientKeyPassword, AuthenticationParams authentication, Builder evidence$4, Reader evidence$5, Function1 evidence$6) {
        return $this.from(server, (Option<File>)ca, (Option<File>)clientCert, (Option<File>)clientKey, (Option<String>)clientKeyPassword, authentication, evidence$4, evidence$5, evidence$6);
    }

    default public <T> HttpClient<?> from(String server, Option<File> ca, Option<File> clientCert, Option<File> clientKey, Option<String> clientKeyPassword, AuthenticationParams authentication, Builder<T> evidence$4, Reader<T> evidence$5, Function1<T, BasicRequestBody> evidence$6) {
        SSLContext ssl = SSLContexts$.MODULE$.fromFile(ca, clientCert, clientKey, clientKeyPassword);
        return HttpClient$.MODULE$.apply(server, SttpKBackend$.MODULE$.apply((SttpBackend)this.buildWithSSLContext().apply((Object)ssl), evidence$4, evidence$5, evidence$6), authentication);
    }

    public static Option from$default$2$(SttpJVM $this) {
        return $this.from$default$2();
    }

    default public <T> Option<File> from$default$2() {
        return None$.MODULE$;
    }

    public static Option from$default$3$(SttpJVM $this) {
        return $this.from$default$3();
    }

    default public <T> Option<File> from$default$3() {
        return None$.MODULE$;
    }

    public static Option from$default$4$(SttpJVM $this) {
        return $this.from$default$4();
    }

    default public <T> Option<File> from$default$4() {
        return None$.MODULE$;
    }

    public static Option from$default$5$(SttpJVM $this) {
        return $this.from$default$5();
    }

    default public <T> Option<String> from$default$5() {
        return None$.MODULE$;
    }

    public static AuthenticationParams from$default$6$(SttpJVM $this) {
        return $this.from$default$6();
    }

    default public <T> AuthenticationParams from$default$6() {
        return AuthenticationParams$.MODULE$.empty();
    }

    public static HttpClient load$(SttpJVM $this, Path config, Option context, Option cluster, Builder evidence$7, Reader evidence$8, Function1 evidence$9) {
        return $this.load(config, (Option<String>)context, (Option<String>)cluster, evidence$7, evidence$8, evidence$9);
    }

    default public <T> HttpClient<?> load(Path config, Option<String> context, Option<String> cluster, Builder<T> evidence$7, Reader<T> evidence$8, Function1<T, BasicRequestBody> evidence$9) {
        String str = this.readFile(config);
        Either either = package$.MODULE$.parse(str, Config$.MODULE$.decoder());
        if (either instanceof Left) {
            Throwable error = (Throwable)((Left)either).value();
            throw error;
        }
        if (either instanceof Right) {
            Config config2 = (Config)((Right)either).value();
            return this.fromConfig(config2, context, cluster, evidence$7, evidence$8, evidence$9);
        }
        throw new MatchError((Object)either);
    }

    public static Option load$default$2$(SttpJVM $this) {
        return $this.load$default$2();
    }

    default public <T> Option<String> load$default$2() {
        return None$.MODULE$;
    }

    public static Option load$default$3$(SttpJVM $this) {
        return $this.load$default$3();
    }

    default public <T> Option<String> load$default$3() {
        return None$.MODULE$;
    }

    public static HttpClient loadFile$(SttpJVM $this, String config, Option context, Option cluster, Builder evidence$10, Reader evidence$11, Function1 evidence$12) {
        return $this.loadFile(config, (Option<String>)context, (Option<String>)cluster, evidence$10, evidence$11, evidence$12);
    }

    default public <T> HttpClient<?> loadFile(String config, Option<String> context, Option<String> cluster, Builder<T> evidence$10, Reader<T> evidence$11, Function1<T, BasicRequestBody> evidence$12) {
        return this.load(Paths.get(config, new String[0]), context, cluster, evidence$10, evidence$11, evidence$12);
    }

    public static Option loadFile$default$2$(SttpJVM $this) {
        return $this.loadFile$default$2();
    }

    default public <T> Option<String> loadFile$default$2() {
        return None$.MODULE$;
    }

    public static Option loadFile$default$3$(SttpJVM $this) {
        return $this.loadFile$default$3();
    }

    default public <T> Option<String> loadFile$default$3() {
        return None$.MODULE$;
    }

    public static HttpClient defaultConfig$(SttpJVM $this, Builder evidence$13, Reader evidence$14, Function1 evidence$15) {
        return $this.defaultConfig(evidence$13, evidence$14, evidence$15);
    }

    default public <T> HttpClient<?> defaultConfig(Builder<T> evidence$13, Reader<T> evidence$14, Function1<T, BasicRequestBody> evidence$15) {
        Option<Path> option = this.homeConfig();
        if (None$.MODULE$.equals(option)) {
            return this.podConfig(evidence$13, evidence$14, evidence$15);
        }
        if (option instanceof Some) {
            Path config = (Path)((Some)option).value();
            return this.load(config, this.load$default$2(), this.load$default$3(), evidence$13, evidence$14, evidence$15);
        }
        throw new MatchError(option);
    }

    public static HttpClient kubeconfig$(SttpJVM $this, Option context, Option cluster, Builder evidence$16, Reader evidence$17, Function1 evidence$18) {
        return $this.kubeconfig((Option<String>)context, (Option<String>)cluster, evidence$16, evidence$17, evidence$18);
    }

    default public <T> HttpClient<?> kubeconfig(Option<String> context, Option<String> cluster, Builder<T> evidence$16, Reader<T> evidence$17, Function1<T, BasicRequestBody> evidence$18) {
        Option<Path> option = this.homeConfig();
        if (None$.MODULE$.equals(option)) {
            throw new FileNotFoundException("No kubeconfig found!");
        }
        if (option instanceof Some) {
            Path configPath = (Path)((Some)option).value();
            return this.load(configPath, context, cluster, evidence$16, evidence$17, evidence$18);
        }
        throw new MatchError(option);
    }

    public static Option kubeconfig$default$1$(SttpJVM $this) {
        return $this.kubeconfig$default$1();
    }

    default public <T> Option<String> kubeconfig$default$1() {
        return None$.MODULE$;
    }

    public static Option kubeconfig$default$2$(SttpJVM $this) {
        return $this.kubeconfig$default$2();
    }

    default public <T> Option<String> kubeconfig$default$2() {
        return None$.MODULE$;
    }

    private String readFile(Path path) {
        return Conversions$.MODULE$.ListHasAsScala(Files.readAllLines(path)).asScala().mkString("\n");
    }

    private Option<Path> homeConfig() {
        Path path;
        String string = System.getProperty("user.home");
        if (string == null) {
            path = Paths.get("~", ".kube", "config");
        } else {
            String value = string;
            path = Paths.get(value, ".kube", "config");
        }
        Path homeConfig = path;
        Option envConfig = scala.sys.package$.MODULE$.env().get((Object)"KUBECONFIG").map((Function1 & Serializable)_$13 -> Paths.get(_$13, new String[0]));
        Path f = (Path)envConfig.getOrElse(() -> SttpJVM.$anonfun$7(homeConfig));
        if (Files.exists(f, new LinkOption[0])) {
            return Some$.MODULE$.apply((Object)f);
        }
        return None$.MODULE$;
    }

    public static HttpClient podConfig$(SttpJVM $this, Builder evidence$19, Reader evidence$20, Function1 evidence$21) {
        return $this.podConfig(evidence$19, evidence$20, evidence$21);
    }

    default public <T> HttpClient<?> podConfig(Builder<T> evidence$19, Reader<T> evidence$20, Function1<T, BasicRequestBody> evidence$21) {
        Path base = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount", new String[0]);
        String apiserver = "https://kubernetes.default.svc";
        Path token = base.resolve("token");
        Path caCert = base.resolve("ca.crt");
        AuthenticationParams tokenAuth = AuthenticationParams$.MODULE$.bearer(this.readFile(token));
        Some some = Some$.MODULE$.apply((Object)caCert.toFile());
        Option<File> option = this.from$default$3();
        Option<File> option2 = this.from$default$4();
        Option<String> option3 = this.from$default$5();
        return this.from(apiserver, (Option<File>)some, option, option2, option3, tokenAuth, evidence$19, evidence$20, evidence$21);
    }

    private static String $anonfun$1(Config config$1) {
        return config$1.current$minuscontext();
    }

    private static String $anonfun$4(NamedContext ctx$1) {
        return ctx$1.context().cluster();
    }

    private static Path $anonfun$7(Path homeConfig$1) {
        return homeConfig$1;
    }
}

