package dev.hnaderi.k8s.scalacheck

import org.scalacheck.Arbitrary
import org.scalacheck.Arbitrary.arbitrary
import org.scalacheck.Gen

private[scalacheck] trait NonPrimitiveGenerators { self : PrimitiveGenerators =>
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressLoadBalancerStatus: Arbitrary[io.k8s.api.networking.v1.IngressLoadBalancerStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressLoadBalancerStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ValidatingAdmissionPolicyBinding: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBinding] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBinding(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Taint: Arbitrary[io.k8s.api.core.v1.Taint] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Taint(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1CinderVolumeSource: Arbitrary[io.k8s.api.core.v1.CinderVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.CinderVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HPAScalingRules: Arbitrary[io.k8s.api.autoscaling.v2.HPAScalingRules] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HPAScalingRules(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LimitRange: Arbitrary[io.k8s.api.core.v1.LimitRange] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LimitRange(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1JobTemplateSpec: Arbitrary[io.k8s.api.batch.v1.JobTemplateSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.JobTemplateSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressClassSpec: Arbitrary[io.k8s.api.networking.v1.IngressClassSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressClassSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1Validation: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.Validation] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.Validation(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1HorizontalPodAutoscaler: Arbitrary[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1HorizontalPodAutoscalerList: Arbitrary[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ServiceSpec: Arbitrary[io.k8s.api.core.v1.ServiceSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ServiceSpec(_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DaemonSetStatus: Arbitrary[io.k8s.api.apps.v1.DaemonSetStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DaemonSetStatus(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SubjectAccessReview: Arbitrary[io.k8s.api.authorization.v1.SubjectAccessReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SubjectAccessReview(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1RollingUpdateStatefulSetStrategy: Arbitrary[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apiserverinternal_v1alpha1StorageVersionList: Arbitrary[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList] =  Arbitrary(Gen.resultOf(io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList(_, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1APIVersions: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressClass: Arbitrary[io.k8s.api.networking.v1.IngressClass] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressClass(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ObjectReference: Arbitrary[io.k8s.api.core.v1.ObjectReference] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ObjectReference(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSINodeList: Arbitrary[io.k8s.api.storage.v1.CSINodeList] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSINodeList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ConfigMapList: Arbitrary[io.k8s.api.core.v1.ConfigMapList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ConfigMapList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EphemeralVolumeSource: Arbitrary[io.k8s.api.core.v1.EphemeralVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EphemeralVolumeSource(_)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3UserSubject: Arbitrary[io.k8s.api.flowcontrol.v1beta3.UserSubject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.UserSubject(_)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSetPersistentVolumeClaimRetentionPolicy: Arbitrary[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1CronJobList: Arbitrary[io.k8s.api.batch.v1.CronJobList] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.CronJobList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SecretList: Arbitrary[io.k8s.api.core.v1.SecretList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SecretList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DaemonSetCondition: Arbitrary[io.k8s.api.apps.v1.DaemonSetCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DaemonSetCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3Subject: Arbitrary[io.k8s.api.flowcontrol.v1beta3.Subject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.Subject(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1VolumeAttachmentSource: Arbitrary[io.k8s.api.storage.v1.VolumeAttachmentSource] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.VolumeAttachmentSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodResourceClaim: Arbitrary[io.k8s.api.core.v1.PodResourceClaim] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodResourceClaim(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PreferredSchedulingTerm: Arbitrary[io.k8s.api.core.v1.PreferredSchedulingTerm] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PreferredSchedulingTerm(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSetStatus: Arbitrary[io.k8s.api.apps.v1.StatefulSetStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSetStatus(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3PriorityLevelConfigurationList: Arbitrary[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationList] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_discovery_v1EndpointSlice: Arbitrary[io.k8s.api.discovery.v1.EndpointSlice] =  Arbitrary(Gen.resultOf(io.k8s.api.discovery.v1.EndpointSlice(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1APIResource: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.APIResource(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3GroupSubject: Arbitrary[io.k8s.api.flowcontrol.v1beta3.GroupSubject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.GroupSubject(_)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2MetricSpec: Arbitrary[io.k8s.api.autoscaling.v2.MetricSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.MetricSpec(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1ReplicaSetSpec: Arbitrary[io.k8s.api.apps.v1.ReplicaSetSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.ReplicaSetSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3ExemptPriorityLevelConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.ExemptPriorityLevelConfiguration(_, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SelfSubjectRulesReview: Arbitrary[io.k8s.api.authorization.v1.SelfSubjectRulesReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SelfSubjectRulesReview(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1StorageOSVolumeSource: Arbitrary[io.k8s.api.core.v1.StorageOSVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.StorageOSVolumeSource(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SessionAffinityConfig: Arbitrary[io.k8s.api.core.v1.SessionAffinityConfig] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SessionAffinityConfig(_)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1DeleteOptions: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_discovery_v1Endpoint: Arbitrary[io.k8s.api.discovery.v1.Endpoint] =  Arbitrary(Gen.resultOf(io.k8s.api.discovery.v1.Endpoint(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1CronJobStatus: Arbitrary[io.k8s.api.batch.v1.CronJobStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.CronJobStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Container: Arbitrary[io.k8s.api.core.v1.Container] =  Arbitrary(for {
      name <- arbitrary[String]
      readinessProbe <- arbitrary[Option[io.k8s.api.core.v1.Probe]]
      livenessProbe <- arbitrary[Option[io.k8s.api.core.v1.Probe]]
      lifecycle <- arbitrary[Option[io.k8s.api.core.v1.Lifecycle]]
      image <- arbitrary[Option[String]]
      resizePolicy <- arbitrary[Option[Seq[io.k8s.api.core.v1.ContainerResizePolicy]]]
      stdinOnce <- arbitrary[Option[Boolean]]
      ports <- arbitrary[Option[Seq[io.k8s.api.core.v1.ContainerPort]]]
      startupProbe <- arbitrary[Option[io.k8s.api.core.v1.Probe]]
      command <- arbitrary[Option[Seq[String]]]
      terminationMessagePolicy <- arbitrary[Option[String]]
      restartPolicy <- arbitrary[Option[String]]
      stdin <- arbitrary[Option[Boolean]]
      terminationMessagePath <- arbitrary[Option[String]]
      resources <- arbitrary[Option[io.k8s.api.core.v1.ResourceRequirements]]
      envFrom <- arbitrary[Option[Seq[io.k8s.api.core.v1.EnvFromSource]]]
      volumeDevices <- arbitrary[Option[Seq[io.k8s.api.core.v1.VolumeDevice]]]
      args <- arbitrary[Option[Seq[String]]]
      tty <- arbitrary[Option[Boolean]]
      imagePullPolicy <- arbitrary[Option[String]]
      workingDir <- arbitrary[Option[String]]
      volumeMounts <- arbitrary[Option[Seq[io.k8s.api.core.v1.VolumeMount]]]
      env <- arbitrary[Option[Seq[io.k8s.api.core.v1.EnvVar]]]
      securityContext <- arbitrary[Option[io.k8s.api.core.v1.SecurityContext]]
    } yield io.k8s.api.core.v1.Container(
      name = name,
      readinessProbe = readinessProbe,
      livenessProbe = livenessProbe,
      lifecycle = lifecycle,
      image = image,
      resizePolicy = resizePolicy,
      stdinOnce = stdinOnce,
      ports = ports,
      startupProbe = startupProbe,
      command = command,
      terminationMessagePolicy = terminationMessagePolicy,
      restartPolicy = restartPolicy,
      stdin = stdin,
      terminationMessagePath = terminationMessagePath,
      resources = resources,
      envFrom = envFrom,
      volumeDevices = volumeDevices,
      args = args,
      tty = tty,
      imagePullPolicy = imagePullPolicy,
      workingDir = workingDir,
      volumeMounts = volumeMounts,
      env = env,
      securityContext = securityContext
    ))
  implicit lazy val arbitrary_io_k8s_api_core_v1EmptyDirVolumeSource: Arbitrary[io.k8s.api.core.v1.EmptyDirVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EmptyDirVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1ScaleSpec: Arbitrary[io.k8s.api.autoscaling.v1.ScaleSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.ScaleSpec(_)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2CrossVersionObjectReference: Arbitrary[io.k8s.api.autoscaling.v2.CrossVersionObjectReference] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.CrossVersionObjectReference(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1ClusterRoleList: Arbitrary[io.k8s.api.rbac.v1.ClusterRoleList] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.ClusterRoleList(_, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinition: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1AggregationRule: Arbitrary[io.k8s.api.rbac.v1.AggregationRule] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.AggregationRule(_)))
  implicit lazy val arbitrary_io_k8s_api_coordination_v1LeaseSpec: Arbitrary[io.k8s.api.coordination.v1.LeaseSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.coordination.v1.LeaseSpec(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LimitRangeSpec: Arbitrary[io.k8s.api.core.v1.LimitRangeSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LimitRangeSpec(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerState: Arbitrary[io.k8s.api.core.v1.ContainerState] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerState(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1alpha1VolumeAttributesClass: Arbitrary[io.k8s.api.storage.v1alpha1.VolumeAttributesClass] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1alpha1.VolumeAttributesClass(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1AuditAnnotation: Arbitrary[io.k8s.api.admissionregistration.v1beta1.AuditAnnotation] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.AuditAnnotation(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1HostPathVolumeSource: Arbitrary[io.k8s.api.core.v1.HostPathVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.HostPathVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1ValidatingWebhookConfiguration: Arbitrary[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeStatus: Arbitrary[io.k8s.api.core.v1.NodeStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeStatus(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1ValidatingWebhookConfigurationList: Arbitrary[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressRule: Arbitrary[io.k8s.api.networking.v1.IngressRule] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressRule(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1TCPSocketAction: Arbitrary[io.k8s.api.core.v1.TCPSocketAction] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.TCPSocketAction(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ValidatingAdmissionPolicyList: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyList] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SecurityContext: Arbitrary[io.k8s.api.core.v1.SecurityContext] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SecurityContext(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1ResourceRule: Arbitrary[io.k8s.api.authorization.v1.ResourceRule] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.ResourceRule(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSetList: Arbitrary[io.k8s.api.apps.v1.StatefulSetList] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSetList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1CertificateSigningRequestStatus: Arbitrary[io.k8s.api.certificates.v1.CertificateSigningRequestStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1.CertificateSigningRequestStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1PodFailurePolicyRule: Arbitrary[io.k8s.api.batch.v1.PodFailurePolicyRule] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.PodFailurePolicyRule(_, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1ListMeta: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1MatchResources: Arbitrary[io.k8s.api.admissionregistration.v1beta1.MatchResources] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.MatchResources(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1HorizontalPodAutoscalerStatus: Arbitrary[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerStatus(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1GitRepoVolumeSource: Arbitrary[io.k8s.api.core.v1.GitRepoVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.GitRepoVolumeSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionStatus: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1beta1SelfSubjectReview: Arbitrary[io.k8s.api.authentication.v1beta1.SelfSubjectReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1beta1.SelfSubjectReview(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ReplicationControllerStatus: Arbitrary[io.k8s.api.core.v1.ReplicationControllerStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ReplicationControllerStatus(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2MetricTarget: Arbitrary[io.k8s.api.autoscaling.v2.MetricTarget] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.MetricTarget(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ISCSIVolumeSource: Arbitrary[io.k8s.api.core.v1.ISCSIVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ISCSIVolumeSource(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1FlowDistinguisherMethod: Arbitrary[io.k8s.api.flowcontrol.v1.FlowDistinguisherMethod] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.FlowDistinguisherMethod(_)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IPBlock: Arbitrary[io.k8s.api.networking.v1.IPBlock] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IPBlock(_, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1BoundObjectReference: Arbitrary[io.k8s.api.authentication.v1.BoundObjectReference] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.BoundObjectReference(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ServiceAccount: Arbitrary[io.k8s.api.core.v1.ServiceAccount] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ServiceAccount(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ValidationRule: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1alpha1ClusterTrustBundle: Arbitrary[io.k8s.api.certificates.v1alpha1.ClusterTrustBundle] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1alpha1.ClusterTrustBundle(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DeploymentSpec: Arbitrary[io.k8s.api.apps.v1.DeploymentSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DeploymentSpec(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ValidatingAdmissionPolicyStatus: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ResourceMetricSource: Arbitrary[io.k8s.api.autoscaling.v2.ResourceMetricSource] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ResourceMetricSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3PriorityLevelConfigurationReference: Arbitrary[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationReference] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationReference(_)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1MatchCondition: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.MatchCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.MatchCondition(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceHandle: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceHandle] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceHandle(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2PodSchedulingContextSpec: Arbitrary[io.k8s.api.resource.v1alpha2.PodSchedulingContextSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.PodSchedulingContextSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1TokenReviewStatus: Arbitrary[io.k8s.api.authentication.v1.TokenReviewStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.TokenReviewStatus(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceCondition: Arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition] =  Arbitrary(Gen.resultOf(io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolume: Arbitrary[io.k8s.api.core.v1.PersistentVolume] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolume(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_coordination_v1Lease: Arbitrary[io.k8s.api.coordination.v1.Lease] =  Arbitrary(Gen.resultOf(io.k8s.api.coordination.v1.Lease(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1MutatingWebhook: Arbitrary[io.k8s.api.admissionregistration.v1.MutatingWebhook] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.MutatingWebhook(_, _, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EnvVarSource: Arbitrary[io.k8s.api.core.v1.EnvVarSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EnvVarSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1CertificateSigningRequestCondition: Arbitrary[io.k8s.api.certificates.v1.CertificateSigningRequestCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1.CertificateSigningRequestCondition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1Validation: Arbitrary[io.k8s.api.admissionregistration.v1beta1.Validation] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.Validation(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1ClusterRoleBinding: Arbitrary[io.k8s.api.rbac.v1.ClusterRoleBinding] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.ClusterRoleBinding(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1FlockerVolumeSource: Arbitrary[io.k8s.api.core.v1.FlockerVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.FlockerVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apiserverinternal_v1alpha1StorageVersion: Arbitrary[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion] =  Arbitrary(Gen.resultOf(io.k8s.api.apiserverinternal.v1alpha1.StorageVersion(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1ServiceCIDRStatus: Arbitrary[io.k8s.api.networking.v1alpha1.ServiceCIDRStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.ServiceCIDRStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ScopedResourceSelectorRequirement: Arbitrary[io.k8s.api.core.v1.ScopedResourceSelectorRequirement] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ScopedResourceSelectorRequirement(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1Job: Arbitrary[io.k8s.api.batch.v1.Job] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.Job(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeConfigSource: Arbitrary[io.k8s.api.core.v1.NodeConfigSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeConfigSource(_)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1FlowSchemaSpec: Arbitrary[io.k8s.api.flowcontrol.v1.FlowSchemaSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.FlowSchemaSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimStatus: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimStatus(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NamespaceCondition: Arbitrary[io.k8s.api.core.v1.NamespaceCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NamespaceCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeSelectorTerm: Arbitrary[io.k8s.api.core.v1.NodeSelectorTerm] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeSelectorTerm(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodList: Arbitrary[io.k8s.api.core.v1.PodList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PortStatus: Arbitrary[io.k8s.api.core.v1.PortStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PortStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1MutatingWebhookConfigurationList: Arbitrary[io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodDNSConfig: Arbitrary[io.k8s.api.core.v1.PodDNSConfig] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodDNSConfig(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressSpec: Arbitrary[io.k8s.api.networking.v1.IngressSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSetSpec: Arbitrary[io.k8s.api.apps.v1.StatefulSetSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSetSpec(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1MatchCondition: Arbitrary[io.k8s.api.admissionregistration.v1beta1.MatchCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.MatchCondition(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Pod: Arbitrary[io.k8s.api.core.v1.Pod] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Pod(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1RoleRef: Arbitrary[io.k8s.api.rbac.v1.RoleRef] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.RoleRef(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ObjectFieldSelector: Arbitrary[io.k8s.api.core.v1.ObjectFieldSelector] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ObjectFieldSelector(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NamespaceSpec: Arbitrary[io.k8s.api.core.v1.NamespaceSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NamespaceSpec(_)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1VolumeNodeResources: Arbitrary[io.k8s.api.storage.v1.VolumeNodeResources] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.VolumeNodeResources(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1CephFSVolumeSource: Arbitrary[io.k8s.api.core.v1.CephFSVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.CephFSVolumeSource(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1ValidatingWebhook: Arbitrary[io.k8s.api.admissionregistration.v1.ValidatingWebhook] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.ValidatingWebhook(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1MatchResources: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.MatchResources] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.MatchResources(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ComponentStatus: Arbitrary[io.k8s.api.core.v1.ComponentStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ComponentStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1NetworkPolicyPeer: Arbitrary[io.k8s.api.networking.v1.NetworkPolicyPeer] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.NetworkPolicyPeer(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_coordination_v1LeaseList: Arbitrary[io.k8s.api.coordination.v1.LeaseList] =  Arbitrary(Gen.resultOf(io.k8s.api.coordination.v1.LeaseList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SleepAction: Arbitrary[io.k8s.api.core.v1.SleepAction] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SleepAction(_)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1TokenReviewSpec: Arbitrary[io.k8s.api.authentication.v1.TokenReviewSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.TokenReviewSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_events_v1EventList: Arbitrary[io.k8s.api.events.v1.EventList] =  Arbitrary(Gen.resultOf(io.k8s.api.events.v1.EventList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2PodSchedulingContextList: Arbitrary[io.k8s.api.resource.v1alpha2.PodSchedulingContextList] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.PodSchedulingContextList(_, _)))
  implicit lazy val arbitrary_io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIService: Arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService] =  Arbitrary(Gen.resultOf(io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SeccompProfile: Arbitrary[io.k8s.api.core.v1.SeccompProfile] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SeccompProfile(_, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionCondition: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ExternalMetricStatus: Arbitrary[io.k8s.api.autoscaling.v2.ExternalMetricStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ExternalMetricStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1PriorityLevelConfigurationSpec: Arbitrary[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationSpec(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ResourceQuotaSpec: Arbitrary[io.k8s.api.core.v1.ResourceQuotaSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ResourceQuotaSpec(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimTemplateSpec: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimTemplateSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimTemplateSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2PodsMetricStatus: Arbitrary[io.k8s.api.autoscaling.v2.PodsMetricStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.PodsMetricStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1FlowSchemaCondition: Arbitrary[io.k8s.api.flowcontrol.v1.FlowSchemaCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.FlowSchemaCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodAffinityTerm: Arbitrary[io.k8s.api.core.v1.PodAffinityTerm] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodAffinityTerm(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1alpha1VolumeAttributesClassList: Arbitrary[io.k8s.api.storage.v1alpha1.VolumeAttributesClassList] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1alpha1.VolumeAttributesClassList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3PriorityLevelConfigurationSpec: Arbitrary[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationSpec(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ValidatingAdmissionPolicyBinding: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBinding(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1ServiceReference: Arbitrary[io.k8s.api.admissionregistration.v1.ServiceReference] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.ServiceReference(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1ResourceAttributes: Arbitrary[io.k8s.api.authorization.v1.ResourceAttributes] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.ResourceAttributes(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DaemonSetUpdateStrategy: Arbitrary[io.k8s.api.apps.v1.DaemonSetUpdateStrategy] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DaemonSetUpdateStrategy(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ObjectMetricSource: Arbitrary[io.k8s.api.autoscaling.v2.ObjectMetricSource] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ObjectMetricSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1Scale: Arbitrary[io.k8s.api.autoscaling.v1.Scale] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.Scale(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Sysctl: Arbitrary[io.k8s.api.core.v1.Sysctl] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Sysctl(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1FCVolumeSource: Arbitrary[io.k8s.api.core.v1.FCVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.FCVolumeSource(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1LimitResponse: Arbitrary[io.k8s.api.flowcontrol.v1.LimitResponse] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.LimitResponse(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodResourceClaimStatus: Arbitrary[io.k8s.api.core.v1.PodResourceClaimStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodResourceClaimStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NamespaceStatus: Arbitrary[io.k8s.api.core.v1.NamespaceStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NamespaceStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodTemplateSpec: Arbitrary[io.k8s.api.core.v1.PodTemplateSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodTemplateSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3FlowSchemaStatus: Arbitrary[io.k8s.api.flowcontrol.v1beta3.FlowSchemaStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.FlowSchemaStatus(_)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1Status: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.Status] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.Status(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3NonResourcePolicyRule: Arbitrary[io.k8s.api.flowcontrol.v1beta3.NonResourcePolicyRule] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.NonResourcePolicyRule(_, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1RoleList: Arbitrary[io.k8s.api.rbac.v1.RoleList] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.RoleList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ServiceAccountTokenProjection: Arbitrary[io.k8s.api.core.v1.ServiceAccountTokenProjection] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ServiceAccountTokenProjection(_, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1GroupVersionForDiscovery: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Capabilities: Arbitrary[io.k8s.api.core.v1.Capabilities] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Capabilities(_, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1WatchEvent: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ParamRef: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ParamRef] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ParamRef(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1RuleWithOperations: Arbitrary[io.k8s.api.admissionregistration.v1.RuleWithOperations] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.RuleWithOperations(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ResourceMetricStatus: Arbitrary[io.k8s.api.autoscaling.v2.ResourceMetricStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ResourceMetricStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1FlexPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.FlexPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.FlexPersistentVolumeSource(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EventList: Arbitrary[io.k8s.api.core.v1.EventList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EventList(_, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1LabelSelector: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ClusterTrustBundleProjection: Arbitrary[io.k8s.api.core.v1.ClusterTrustBundleProjection] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ClusterTrustBundleProjection(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSIDriverSpec: Arbitrary[io.k8s.api.storage.v1.CSIDriverSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSIDriverSpec(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1CrossVersionObjectReference: Arbitrary[io.k8s.api.autoscaling.v1.CrossVersionObjectReference] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.CrossVersionObjectReference(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1ResourcePolicyRule: Arbitrary[io.k8s.api.flowcontrol.v1.ResourcePolicyRule] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.ResourcePolicyRule(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2MetricValueStatus: Arbitrary[io.k8s.api.autoscaling.v2.MetricValueStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.MetricValueStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodReadinessGate: Arbitrary[io.k8s.api.core.v1.PodReadinessGate] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodReadinessGate(_)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1ControllerRevision: Arbitrary[io.k8s.api.apps.v1.ControllerRevision] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.ControllerRevision(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1ServiceCIDRList: Arbitrary[io.k8s.api.networking.v1alpha1.ServiceCIDRList] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.ServiceCIDRList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1Subject: Arbitrary[io.k8s.api.flowcontrol.v1.Subject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.Subject(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1Variable: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.Variable] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.Variable(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Lifecycle: Arbitrary[io.k8s.api.core.v1.Lifecycle] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Lifecycle(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressServiceBackend: Arbitrary[io.k8s.api.networking.v1.IngressServiceBackend] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressServiceBackend(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1AttachedVolume: Arbitrary[io.k8s.api.core.v1.AttachedVolume] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.AttachedVolume(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1TypeChecking: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.TypeChecking] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.TypeChecking(_)))
  implicit lazy val arbitrary_io_k8s_api_discovery_v1ForZone: Arbitrary[io.k8s.api.discovery.v1.ForZone] =  Arbitrary(Gen.resultOf(io.k8s.api.discovery.v1.ForZone(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1HostIP: Arbitrary[io.k8s.api.core.v1.HostIP] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.HostIP(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SecretEnvSource: Arbitrary[io.k8s.api.core.v1.SecretEnvSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SecretEnvSource(_, _)))
  implicit lazy val arbitrary_io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceSpec: Arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec] =  Arbitrary(Gen.resultOf(io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_discovery_v1EndpointHints: Arbitrary[io.k8s.api.discovery.v1.EndpointHints] =  Arbitrary(Gen.resultOf(io.k8s.api.discovery.v1.EndpointHints(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ComponentCondition: Arbitrary[io.k8s.api.core.v1.ComponentCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ComponentCondition(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1JobSpec: Arbitrary[io.k8s.api.batch.v1.JobSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.JobSpec(_, _, _, _, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_discovery_v1EndpointConditions: Arbitrary[io.k8s.api.discovery.v1.EndpointConditions] =  Arbitrary(Gen.resultOf(io.k8s.api.discovery.v1.EndpointConditions(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodTemplateList: Arbitrary[io.k8s.api.core.v1.PodTemplateList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodTemplateList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ValidatingAdmissionPolicyList: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyList] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1MutatingWebhookConfiguration: Arbitrary[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ResourceRequirements: Arbitrary[io.k8s.api.core.v1.ResourceRequirements] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ResourceRequirements(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1UserSubject: Arbitrary[io.k8s.api.flowcontrol.v1.UserSubject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.UserSubject(_)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3ServiceAccountSubject: Arbitrary[io.k8s.api.flowcontrol.v1beta3.ServiceAccountSubject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.ServiceAccountSubject(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1PodFailurePolicyOnPodConditionsPattern: Arbitrary[io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.PodFailurePolicyOnPodConditionsPattern(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSet: Arbitrary[io.k8s.api.apps.v1.StatefulSet] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSet(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ServiceAccountList: Arbitrary[io.k8s.api.core.v1.ServiceAccountList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ServiceAccountList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ValidatingAdmissionPolicyBindingList: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingList] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1VolumeProjection: Arbitrary[io.k8s.api.core.v1.VolumeProjection] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.VolumeProjection(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerPort: Arbitrary[io.k8s.api.core.v1.ContainerPort] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerPort(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceList: Arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList] =  Arbitrary(Gen.resultOf(io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimSchedulingStatus: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimSchedulingStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_events_v1EventSeries: Arbitrary[io.k8s.api.events.v1.EventSeries] =  Arbitrary(Gen.resultOf(io.k8s.api.events.v1.EventSeries(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Toleration: Arbitrary[io.k8s.api.core.v1.Toleration] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Toleration(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ScaleIOVolumeSource: Arbitrary[io.k8s.api.core.v1.ScaleIOVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ScaleIOVolumeSource(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1GCEPersistentDiskVolumeSource: Arbitrary[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.GCEPersistentDiskVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3FlowDistinguisherMethod: Arbitrary[io.k8s.api.flowcontrol.v1beta3.FlowDistinguisherMethod] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.FlowDistinguisherMethod(_)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1APIResourceList: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1CSIVolumeSource: Arbitrary[io.k8s.api.core.v1.CSIVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.CSIVolumeSource(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LimitRangeList: Arbitrary[io.k8s.api.core.v1.LimitRangeList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LimitRangeList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1WeightedPodAffinityTerm: Arbitrary[io.k8s.api.core.v1.WeightedPodAffinityTerm] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.WeightedPodAffinityTerm(_, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SelfSubjectAccessReviewSpec: Arbitrary[io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_policy_v1PodDisruptionBudget: Arbitrary[io.k8s.api.policy.v1.PodDisruptionBudget] =  Arbitrary(Gen.resultOf(io.k8s.api.policy.v1.PodDisruptionBudget(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ServiceStatus: Arbitrary[io.k8s.api.core.v1.ServiceStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ServiceStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1Subject: Arbitrary[io.k8s.api.rbac.v1.Subject] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.Subject(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1Ingress: Arbitrary[io.k8s.api.networking.v1.Ingress] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.Ingress(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3LimitResponse: Arbitrary[io.k8s.api.flowcontrol.v1beta3.LimitResponse] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.LimitResponse(_, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1WebhookConversion: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeAffinity: Arbitrary[io.k8s.api.core.v1.NodeAffinity] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeAffinity(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ValidatingAdmissionPolicy: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicy(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1PriorityLevelConfigurationReference: Arbitrary[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationReference] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationReference(_)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressClassList: Arbitrary[io.k8s.api.networking.v1.IngressClassList] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressClassList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1CertificateSigningRequestList: Arbitrary[io.k8s.api.certificates.v1.CertificateSigningRequestList] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1.CertificateSigningRequestList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodStatus: Arbitrary[io.k8s.api.core.v1.PodStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodStatus(_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1StorageOSPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.StorageOSPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.StorageOSPersistentVolumeSource(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1WebhookClientConfig: Arbitrary[io.k8s.api.admissionregistration.v1.WebhookClientConfig] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.WebhookClientConfig(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSIStorageCapacity: Arbitrary[io.k8s.api.storage.v1.CSIStorageCapacity] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSIStorageCapacity(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerStatus: Arbitrary[io.k8s.api.core.v1.ContainerStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerStatus(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ResourceFieldSelector: Arbitrary[io.k8s.api.core.v1.ResourceFieldSelector] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ResourceFieldSelector(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1KeyToPath: Arbitrary[io.k8s.api.core.v1.KeyToPath] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.KeyToPath(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SubjectRulesReviewStatus: Arbitrary[io.k8s.api.authorization.v1.SubjectRulesReviewStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SubjectRulesReviewStatus(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ScaleIOPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ScaleIOPersistentVolumeSource(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1PodFailurePolicy: Arbitrary[io.k8s.api.batch.v1.PodFailurePolicy] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.PodFailurePolicy(_)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressPortStatus: Arbitrary[io.k8s.api.networking.v1.IngressPortStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressPortStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionList: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1FlowSchema: Arbitrary[io.k8s.api.flowcontrol.v1.FlowSchema] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.FlowSchema(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1NetworkPolicyIngressRule: Arbitrary[io.k8s.api.networking.v1.NetworkPolicyIngressRule] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.NetworkPolicyIngressRule(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1ParentReference: Arbitrary[io.k8s.api.networking.v1alpha1.ParentReference] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.ParentReference(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LoadBalancerIngress: Arbitrary[io.k8s.api.core.v1.LoadBalancerIngress] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LoadBalancerIngress(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodSchedulingGate: Arbitrary[io.k8s.api.core.v1.PodSchedulingGate] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodSchedulingGate(_)))
  implicit lazy val arbitrary_io_k8s_api_apiserverinternal_v1alpha1ServerStorageVersion: Arbitrary[io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion] =  Arbitrary(Gen.resultOf(io.k8s.api.apiserverinternal.v1alpha1.ServerStorageVersion(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1HorizontalPodAutoscalerSpec: Arbitrary[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ParamRef: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ParamRef] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ParamRef(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeSpec: Arbitrary[io.k8s.api.core.v1.PersistentVolumeSpec] =  Arbitrary(for {
      scaleIO <- arbitrary[Option[io.k8s.api.core.v1.ScaleIOPersistentVolumeSource]]
      csi <- arbitrary[Option[io.k8s.api.core.v1.CSIPersistentVolumeSource]]
      accessModes <- arbitrary[Option[Seq[String]]]
      mountOptions <- arbitrary[Option[Seq[String]]]
      nodeAffinity <- arbitrary[Option[io.k8s.api.core.v1.VolumeNodeAffinity]]
      azureDisk <- arbitrary[Option[io.k8s.api.core.v1.AzureDiskVolumeSource]]
      azureFile <- arbitrary[Option[io.k8s.api.core.v1.AzureFilePersistentVolumeSource]]
      hostPath <- arbitrary[Option[io.k8s.api.core.v1.HostPathVolumeSource]]
      rbd <- arbitrary[Option[io.k8s.api.core.v1.RBDPersistentVolumeSource]]
      portworxVolume <- arbitrary[Option[io.k8s.api.core.v1.PortworxVolumeSource]]
      persistentVolumeReclaimPolicy <- arbitrary[Option[String]]
      glusterfs <- arbitrary[Option[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource]]
      volumeMode <- arbitrary[Option[String]]
      flocker <- arbitrary[Option[io.k8s.api.core.v1.FlockerVolumeSource]]
      claimRef <- arbitrary[Option[io.k8s.api.core.v1.ObjectReference]]
      fc <- arbitrary[Option[io.k8s.api.core.v1.FCVolumeSource]]
      local <- arbitrary[Option[io.k8s.api.core.v1.LocalVolumeSource]]
      storageClassName <- arbitrary[Option[String]]
      photonPersistentDisk <- arbitrary[Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource]]
      gcePersistentDisk <- arbitrary[Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource]]
      vsphereVolume <- arbitrary[Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource]]
      iscsi <- arbitrary[Option[io.k8s.api.core.v1.ISCSIPersistentVolumeSource]]
      cinder <- arbitrary[Option[io.k8s.api.core.v1.CinderPersistentVolumeSource]]
      cephfs <- arbitrary[Option[io.k8s.api.core.v1.CephFSPersistentVolumeSource]]
      awsElasticBlockStore <- arbitrary[Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource]]
      volumeAttributesClassName <- arbitrary[Option[String]]
      flexVolume <- arbitrary[Option[io.k8s.api.core.v1.FlexPersistentVolumeSource]]
      nfs <- arbitrary[Option[io.k8s.api.core.v1.NFSVolumeSource]]
      quobyte <- arbitrary[Option[io.k8s.api.core.v1.QuobyteVolumeSource]]
      storageos <- arbitrary[Option[io.k8s.api.core.v1.StorageOSPersistentVolumeSource]]
      capacity <- arbitrary[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]
    } yield io.k8s.api.core.v1.PersistentVolumeSpec(
      scaleIO = scaleIO,
      csi = csi,
      accessModes = accessModes,
      mountOptions = mountOptions,
      nodeAffinity = nodeAffinity,
      azureDisk = azureDisk,
      azureFile = azureFile,
      hostPath = hostPath,
      rbd = rbd,
      portworxVolume = portworxVolume,
      persistentVolumeReclaimPolicy = persistentVolumeReclaimPolicy,
      glusterfs = glusterfs,
      volumeMode = volumeMode,
      flocker = flocker,
      claimRef = claimRef,
      fc = fc,
      local = local,
      storageClassName = storageClassName,
      photonPersistentDisk = photonPersistentDisk,
      gcePersistentDisk = gcePersistentDisk,
      vsphereVolume = vsphereVolume,
      iscsi = iscsi,
      cinder = cinder,
      cephfs = cephfs,
      awsElasticBlockStore = awsElasticBlockStore,
      volumeAttributesClassName = volumeAttributesClassName,
      flexVolume = flexVolume,
      nfs = nfs,
      quobyte = quobyte,
      storageos = storageos,
      capacity = capacity
    ))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1PriorityLevelConfigurationCondition: Arbitrary[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1GroupSubject: Arbitrary[io.k8s.api.flowcontrol.v1.GroupSubject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.GroupSubject(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodSecurityContext: Arbitrary[io.k8s.api.core.v1.PodSecurityContext] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodSecurityContext(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1Preconditions: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.Preconditions(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PhotonPersistentDiskVolumeSource: Arbitrary[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1VolumeError: Arbitrary[io.k8s.api.storage.v1.VolumeError] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.VolumeError(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DaemonSetSpec: Arbitrary[io.k8s.api.apps.v1.DaemonSetSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DaemonSetSpec(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1HTTPHeader: Arbitrary[io.k8s.api.core.v1.HTTPHeader] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.HTTPHeader(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2AllocationResult: Arbitrary[io.k8s.api.resource.v1alpha2.AllocationResult] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.AllocationResult(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_events_v1Event: Arbitrary[io.k8s.api.events.v1.Event] =  Arbitrary(Gen.resultOf(io.k8s.api.events.v1.Event(_, _, _, _, _, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DaemonSet: Arbitrary[io.k8s.api.apps.v1.DaemonSet] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DaemonSet(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1VolumeAttachmentStatus: Arbitrary[io.k8s.api.storage.v1.VolumeAttachmentStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.VolumeAttachmentStatus(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1PolicyRulesWithSubjects: Arbitrary[io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.PolicyRulesWithSubjects(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1AzureFileVolumeSource: Arbitrary[io.k8s.api.core.v1.AzureFileVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.AzureFileVolumeSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_discovery_v1EndpointPort: Arbitrary[io.k8s.api.discovery.v1.EndpointPort] =  Arbitrary(Gen.resultOf(io.k8s.api.discovery.v1.EndpointPort(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1NetworkPolicyPort: Arbitrary[io.k8s.api.networking.v1.NetworkPolicyPort] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.NetworkPolicyPort(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SelfSubjectAccessReview: Arbitrary[io.k8s.api.authorization.v1.SelfSubjectAccessReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SelfSubjectAccessReview(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1JobList: Arbitrary[io.k8s.api.batch.v1.JobList] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.JobList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1RoleBinding: Arbitrary[io.k8s.api.rbac.v1.RoleBinding] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.RoleBinding(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1FlowSchemaStatus: Arbitrary[io.k8s.api.flowcontrol.v1.FlowSchemaStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.FlowSchemaStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1alpha1SelfSubjectReviewStatus: Arbitrary[io.k8s.api.authentication.v1alpha1.SelfSubjectReviewStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1alpha1.SelfSubjectReviewStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HorizontalPodAutoscalerBehavior: Arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1IPAddressSpec: Arbitrary[io.k8s.api.networking.v1alpha1.IPAddressSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.IPAddressSpec(_)))
  implicit lazy val arbitrary_io_k8s_api_policy_v1PodDisruptionBudgetSpec: Arbitrary[io.k8s.api.policy.v1.PodDisruptionBudgetSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.policy.v1.PodDisruptionBudgetSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SecretProjection: Arbitrary[io.k8s.api.core.v1.SecretProjection] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SecretProjection(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ValidatingAdmissionPolicyBindingList: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBindingList] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBindingList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSetOrdinals: Arbitrary[io.k8s.api.apps.v1.StatefulSetOrdinals] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSetOrdinals(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Secret: Arbitrary[io.k8s.api.core.v1.Secret] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Secret(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ResourceQuota: Arbitrary[io.k8s.api.core.v1.ResourceQuota] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ResourceQuota(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DeploymentList: Arbitrary[io.k8s.api.apps.v1.DeploymentList] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DeploymentList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EventSource: Arbitrary[io.k8s.api.core.v1.EventSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EventSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodIP: Arbitrary[io.k8s.api.core.v1.PodIP] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodIP(_)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3PriorityLevelConfigurationStatus: Arbitrary[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ValidatingAdmissionPolicySpec: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicySpec(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeSystemInfo: Arbitrary[io.k8s.api.core.v1.NodeSystemInfo] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeSystemInfo(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Binding: Arbitrary[io.k8s.api.core.v1.Binding] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Binding(_, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionSpec: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1AuditAnnotation: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.AuditAnnotation(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1CronJob: Arbitrary[io.k8s.api.batch.v1.CronJob] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.CronJob(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1QueuingConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1.QueuingConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.QueuingConfiguration(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClassParametersReference: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClassParametersReference] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClassParametersReference(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSINode: Arbitrary[io.k8s.api.storage.v1.CSINode] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSINode(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSIDriver: Arbitrary[io.k8s.api.storage.v1.CSIDriver] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSIDriver(_, _)))
  implicit lazy val arbitrary_io_k8s_api_node_v1Overhead: Arbitrary[io.k8s.api.node.v1.Overhead] =  Arbitrary(Gen.resultOf(io.k8s.api.node.v1.Overhead(_)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2PodSchedulingContext: Arbitrary[io.k8s.api.resource.v1alpha2.PodSchedulingContext] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.PodSchedulingContext(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EndpointsList: Arbitrary[io.k8s.api.core.v1.EndpointsList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EndpointsList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSINodeSpec: Arbitrary[io.k8s.api.storage.v1.CSINodeSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSINodeSpec(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ClaimSource: Arbitrary[io.k8s.api.core.v1.ClaimSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ClaimSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_node_v1RuntimeClassList: Arbitrary[io.k8s.api.node.v1.RuntimeClassList] =  Arbitrary(Gen.resultOf(io.k8s.api.node.v1.RuntimeClassList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ReplicationController: Arbitrary[io.k8s.api.core.v1.ReplicationController] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ReplicationController(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ResourceQuotaStatus: Arbitrary[io.k8s.api.core.v1.ResourceQuotaStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ResourceQuotaStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ValidatingAdmissionPolicyBindingSpec: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBindingSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyBindingSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1ClusterRole: Arbitrary[io.k8s.api.rbac.v1.ClusterRole] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.ClusterRole(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1TypeChecking: Arbitrary[io.k8s.api.admissionregistration.v1beta1.TypeChecking] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.TypeChecking(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1CephFSPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.CephFSPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.CephFSPersistentVolumeSource(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1NamedRuleWithOperations: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.NamedRuleWithOperations] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.NamedRuleWithOperations(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ScopeSelector: Arbitrary[io.k8s.api.core.v1.ScopeSelector] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ScopeSelector(_)))
  implicit lazy val arbitrary_io_k8s_api_scheduling_v1PriorityClassList: Arbitrary[io.k8s.api.scheduling.v1.PriorityClassList] =  Arbitrary(Gen.resultOf(io.k8s.api.scheduling.v1.PriorityClassList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1VsphereVirtualDiskVolumeSource: Arbitrary[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1VolumeAttachmentList: Arbitrary[io.k8s.api.storage.v1.VolumeAttachmentList] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.VolumeAttachmentList(_, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1WebhookClientConfig: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1TokenRequest: Arbitrary[io.k8s.api.authentication.v1.TokenRequest] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.TokenRequest(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeClaim: Arbitrary[io.k8s.api.core.v1.PersistentVolumeClaim] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeClaim(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LimitRangeItem: Arbitrary[io.k8s.api.core.v1.LimitRangeItem] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LimitRangeItem(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1NonResourceRule: Arbitrary[io.k8s.api.authorization.v1.NonResourceRule] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.NonResourceRule(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1TokenRequest: Arbitrary[io.k8s.api.storage.v1.TokenRequest] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.TokenRequest(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LocalObjectReference: Arbitrary[io.k8s.api.core.v1.LocalObjectReference] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LocalObjectReference(_)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2PodSchedulingContextStatus: Arbitrary[io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.PodSchedulingContextStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1DaemonEndpoint: Arbitrary[io.k8s.api.core.v1.DaemonEndpoint] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.DaemonEndpoint(_)))
  implicit lazy val arbitrary_io_k8s_api_apiserverinternal_v1alpha1StorageVersionStatus: Arbitrary[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.apiserverinternal.v1alpha1.StorageVersionStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EndpointPort: Arbitrary[io.k8s.api.core.v1.EndpointPort] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EndpointPort(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ConfigMapVolumeSource: Arbitrary[io.k8s.api.core.v1.ConfigMapVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ConfigMapVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeSelectorRequirement: Arbitrary[io.k8s.api.core.v1.NodeSelectorRequirement] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeSelectorRequirement(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimSpec: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimSpec(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodTemplate: Arbitrary[io.k8s.api.core.v1.PodTemplate] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodTemplate(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1RollingUpdateDaemonSet: Arbitrary[io.k8s.api.apps.v1.RollingUpdateDaemonSet] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.RollingUpdateDaemonSet(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HorizontalPodAutoscalerCondition: Arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressStatus: Arbitrary[io.k8s.api.networking.v1.IngressStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressStatus(_)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceConversion: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1FlowSchemaList: Arbitrary[io.k8s.api.flowcontrol.v1.FlowSchemaList] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.FlowSchemaList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSIDriverList: Arbitrary[io.k8s.api.storage.v1.CSIDriverList] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSIDriverList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressList: Arbitrary[io.k8s.api.networking.v1.IngressList] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SubjectAccessReviewStatus: Arbitrary[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SubjectAccessReviewStatus(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1WindowsSecurityContextOptions: Arbitrary[io.k8s.api.core.v1.WindowsSecurityContextOptions] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.WindowsSecurityContextOptions(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HPAScalingPolicy: Arbitrary[io.k8s.api.autoscaling.v2.HPAScalingPolicy] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HPAScalingPolicy(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DeploymentCondition: Arbitrary[io.k8s.api.apps.v1.DeploymentCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DeploymentCondition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1StatusCause: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.StatusCause(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1TokenRequestStatus: Arbitrary[io.k8s.api.authentication.v1.TokenRequestStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.TokenRequestStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1ServerAddressByClientCIDR: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2MetricIdentifier: Arbitrary[io.k8s.api.autoscaling.v2.MetricIdentifier] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.MetricIdentifier(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1GRPCAction: Arbitrary[io.k8s.api.core.v1.GRPCAction] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.GRPCAction(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ResourceClaim: Arbitrary[io.k8s.api.core.v1.ResourceClaim] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ResourceClaim(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1CSIPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.CSIPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.CSIPersistentVolumeSource(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_policy_v1Eviction: Arbitrary[io.k8s.api.policy.v1.Eviction] =  Arbitrary(Gen.resultOf(io.k8s.api.policy.v1.Eviction(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodCondition: Arbitrary[io.k8s.api.core.v1.PodCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodCondition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1PriorityLevelConfigurationStatus: Arbitrary[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1GlusterfsVolumeSource: Arbitrary[io.k8s.api.core.v1.GlusterfsVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.GlusterfsVolumeSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1SelfSubjectReview: Arbitrary[io.k8s.api.authentication.v1.SelfSubjectReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.SelfSubjectReview(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1NamedRuleWithOperations: Arbitrary[io.k8s.api.admissionregistration.v1beta1.NamedRuleWithOperations] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.NamedRuleWithOperations(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1PolicyRule: Arbitrary[io.k8s.api.rbac.v1.PolicyRule] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.PolicyRule(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ServiceReference: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1Condition: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.Condition] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.Condition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_kube_aggregator_pkg_apis_apiregistration_v1APIServiceStatus: Arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus] =  Arbitrary(Gen.resultOf(io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceStatus(_)))
  implicit lazy val arbitrary_io_k8s_kube_aggregator_pkg_apis_apiregistration_v1ServiceReference: Arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference] =  Arbitrary(Gen.resultOf(io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1HTTPIngressPath: Arbitrary[io.k8s.api.networking.v1.HTTPIngressPath] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.HTTPIngressPath(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Endpoints: Arbitrary[io.k8s.api.core.v1.Endpoints] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Endpoints(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Volume: Arbitrary[io.k8s.api.core.v1.Volume] =  Arbitrary(for {
      name <- arbitrary[String]
      secret <- arbitrary[Option[io.k8s.api.core.v1.SecretVolumeSource]]
      scaleIO <- arbitrary[Option[io.k8s.api.core.v1.ScaleIOVolumeSource]]
      csi <- arbitrary[Option[io.k8s.api.core.v1.CSIVolumeSource]]
      azureDisk <- arbitrary[Option[io.k8s.api.core.v1.AzureDiskVolumeSource]]
      azureFile <- arbitrary[Option[io.k8s.api.core.v1.AzureFileVolumeSource]]
      hostPath <- arbitrary[Option[io.k8s.api.core.v1.HostPathVolumeSource]]
      rbd <- arbitrary[Option[io.k8s.api.core.v1.RBDVolumeSource]]
      configMap <- arbitrary[Option[io.k8s.api.core.v1.ConfigMapVolumeSource]]
      portworxVolume <- arbitrary[Option[io.k8s.api.core.v1.PortworxVolumeSource]]
      glusterfs <- arbitrary[Option[io.k8s.api.core.v1.GlusterfsVolumeSource]]
      flocker <- arbitrary[Option[io.k8s.api.core.v1.FlockerVolumeSource]]
      fc <- arbitrary[Option[io.k8s.api.core.v1.FCVolumeSource]]
      photonPersistentDisk <- arbitrary[Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource]]
      gcePersistentDisk <- arbitrary[Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource]]
      persistentVolumeClaim <- arbitrary[Option[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource]]
      vsphereVolume <- arbitrary[Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource]]
      projected <- arbitrary[Option[io.k8s.api.core.v1.ProjectedVolumeSource]]
      ephemeral <- arbitrary[Option[io.k8s.api.core.v1.EphemeralVolumeSource]]
      iscsi <- arbitrary[Option[io.k8s.api.core.v1.ISCSIVolumeSource]]
      cinder <- arbitrary[Option[io.k8s.api.core.v1.CinderVolumeSource]]
      gitRepo <- arbitrary[Option[io.k8s.api.core.v1.GitRepoVolumeSource]]
      cephfs <- arbitrary[Option[io.k8s.api.core.v1.CephFSVolumeSource]]
      awsElasticBlockStore <- arbitrary[Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource]]
      downwardAPI <- arbitrary[Option[io.k8s.api.core.v1.DownwardAPIVolumeSource]]
      flexVolume <- arbitrary[Option[io.k8s.api.core.v1.FlexVolumeSource]]
      emptyDir <- arbitrary[Option[io.k8s.api.core.v1.EmptyDirVolumeSource]]
      nfs <- arbitrary[Option[io.k8s.api.core.v1.NFSVolumeSource]]
      quobyte <- arbitrary[Option[io.k8s.api.core.v1.QuobyteVolumeSource]]
      storageos <- arbitrary[Option[io.k8s.api.core.v1.StorageOSVolumeSource]]
    } yield io.k8s.api.core.v1.Volume(
      name = name,
      secret = secret,
      scaleIO = scaleIO,
      csi = csi,
      azureDisk = azureDisk,
      azureFile = azureFile,
      hostPath = hostPath,
      rbd = rbd,
      configMap = configMap,
      portworxVolume = portworxVolume,
      glusterfs = glusterfs,
      flocker = flocker,
      fc = fc,
      photonPersistentDisk = photonPersistentDisk,
      gcePersistentDisk = gcePersistentDisk,
      persistentVolumeClaim = persistentVolumeClaim,
      vsphereVolume = vsphereVolume,
      projected = projected,
      ephemeral = ephemeral,
      iscsi = iscsi,
      cinder = cinder,
      gitRepo = gitRepo,
      cephfs = cephfs,
      awsElasticBlockStore = awsElasticBlockStore,
      downwardAPI = downwardAPI,
      flexVolume = flexVolume,
      emptyDir = emptyDir,
      nfs = nfs,
      quobyte = quobyte,
      storageos = storageos
    ))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3ResourcePolicyRule: Arbitrary[io.k8s.api.flowcontrol.v1beta3.ResourcePolicyRule] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.ResourcePolicyRule(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1PriorityLevelConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1.PriorityLevelConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.PriorityLevelConfiguration(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3FlowSchemaCondition: Arbitrary[io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.FlowSchemaCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaim: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaim] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaim(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeList: Arbitrary[io.k8s.api.core.v1.PersistentVolumeList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EnvFromSource: Arbitrary[io.k8s.api.core.v1.EnvFromSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EnvFromSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3FlowSchemaSpec: Arbitrary[io.k8s.api.flowcontrol.v1beta3.FlowSchemaSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.FlowSchemaSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1ExternalDocumentation: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1PriorityLevelConfigurationList: Arbitrary[io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationList] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.PriorityLevelConfigurationList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeClaimStatus: Arbitrary[io.k8s.api.core.v1.PersistentVolumeClaimStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeClaimStatus(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_node_v1RuntimeClass: Arbitrary[io.k8s.api.node.v1.RuntimeClass] =  Arbitrary(Gen.resultOf(io.k8s.api.node.v1.RuntimeClass(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1TopologySelectorTerm: Arbitrary[io.k8s.api.core.v1.TopologySelectorTerm] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.TopologySelectorTerm(_)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ExpressionWarning: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ExpressionWarning] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ExpressionWarning(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeSelector: Arbitrary[io.k8s.api.core.v1.NodeSelector] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeSelector(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1CinderPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.CinderPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.CinderPersistentVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ValidatingAdmissionPolicyBindingSpec: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ValidatingAdmissionPolicyBindingSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LifecycleHandler: Arbitrary[io.k8s.api.core.v1.LifecycleHandler] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LifecycleHandler(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1TypedLocalObjectReference: Arbitrary[io.k8s.api.core.v1.TypedLocalObjectReference] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.TypedLocalObjectReference(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3PriorityLevelConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfiguration(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HorizontalPodAutoscalerStatus: Arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerStatus(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1APIGroupList: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList(_)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1RollingUpdateDeployment: Arbitrary[io.k8s.api.apps.v1.RollingUpdateDeployment] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.RollingUpdateDeployment(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClass: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClass] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClass(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1PodFailurePolicyOnExitCodesRequirement: Arbitrary[io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.PodFailurePolicyOnExitCodesRequirement(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimConsumerReference: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimConsumerReference(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1DownwardAPIVolumeSource: Arbitrary[io.k8s.api.core.v1.DownwardAPIVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.DownwardAPIVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ExternalMetricSource: Arbitrary[io.k8s.api.autoscaling.v2.ExternalMetricSource] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ExternalMetricSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1AzureFilePersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.AzureFilePersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.AzureFilePersistentVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1IPAddress: Arbitrary[io.k8s.api.networking.v1alpha1.IPAddress] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.IPAddress(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HorizontalPodAutoscalerList: Arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ConfigMapNodeConfigSource: Arbitrary[io.k8s.api.core.v1.ConfigMapNodeConfigSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ConfigMapNodeConfigSource(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerStateWaiting: Arbitrary[io.k8s.api.core.v1.ContainerStateWaiting] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerStateWaiting(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1ServiceCIDR: Arbitrary[io.k8s.api.networking.v1alpha1.ServiceCIDR] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.ServiceCIDR(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressLoadBalancerIngress: Arbitrary[io.k8s.api.networking.v1.IngressLoadBalancerIngress] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressLoadBalancerIngress(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ConfigMapEnvSource: Arbitrary[io.k8s.api.core.v1.ConfigMapEnvSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ConfigMapEnvSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1JobCondition: Arbitrary[io.k8s.api.batch.v1.JobCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.JobCondition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Service: Arbitrary[io.k8s.api.core.v1.Service] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Service(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1UserInfo: Arbitrary[io.k8s.api.authentication.v1.UserInfo] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.UserInfo(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ReplicationControllerCondition: Arbitrary[io.k8s.api.core.v1.ReplicationControllerCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ReplicationControllerCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1IPAddressList: Arbitrary[io.k8s.api.networking.v1alpha1.IPAddressList] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.IPAddressList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerStateRunning: Arbitrary[io.k8s.api.core.v1.ContainerStateRunning] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerStateRunning(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodSpec: Arbitrary[io.k8s.api.core.v1.PodSpec] =  Arbitrary(for {
      containers <- arbitrary[Seq[io.k8s.api.core.v1.Container]]
      schedulingGates <- arbitrary[Option[Seq[io.k8s.api.core.v1.PodSchedulingGate]]]
      priority <- arbitrary[Option[Int]]
      hostIPC <- arbitrary[Option[Boolean]]
      serviceAccount <- arbitrary[Option[String]]
      schedulerName <- arbitrary[Option[String]]
      hostname <- arbitrary[Option[String]]
      imagePullSecrets <- arbitrary[Option[Seq[io.k8s.api.core.v1.LocalObjectReference]]]
      affinity <- arbitrary[Option[io.k8s.api.core.v1.Affinity]]
      os <- arbitrary[Option[io.k8s.api.core.v1.PodOS]]
      nodeName <- arbitrary[Option[String]]
      ephemeralContainers <- arbitrary[Option[Seq[io.k8s.api.core.v1.EphemeralContainer]]]
      initContainers <- arbitrary[Option[Seq[io.k8s.api.core.v1.Container]]]
      shareProcessNamespace <- arbitrary[Option[Boolean]]
      setHostnameAsFQDN <- arbitrary[Option[Boolean]]
      enableServiceLinks <- arbitrary[Option[Boolean]]
      preemptionPolicy <- arbitrary[Option[String]]
      dnsPolicy <- arbitrary[Option[String]]
      volumes <- arbitrary[Option[Seq[io.k8s.api.core.v1.Volume]]]
      hostAliases <- arbitrary[Option[Seq[io.k8s.api.core.v1.HostAlias]]]
      subdomain <- arbitrary[Option[String]]
      topologySpreadConstraints <- arbitrary[Option[Seq[io.k8s.api.core.v1.TopologySpreadConstraint]]]
      overhead <- arbitrary[Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]]
      tolerations <- arbitrary[Option[Seq[io.k8s.api.core.v1.Toleration]]]
      automountServiceAccountToken <- arbitrary[Option[Boolean]]
      nodeSelector <- arbitrary[Option[Map[String, String]]]
      hostPID <- arbitrary[Option[Boolean]]
      terminationGracePeriodSeconds <- arbitrary[Option[Long]]
      dnsConfig <- arbitrary[Option[io.k8s.api.core.v1.PodDNSConfig]]
      priorityClassName <- arbitrary[Option[String]]
      serviceAccountName <- arbitrary[Option[String]]
      restartPolicy <- arbitrary[Option[String]]
      resourceClaims <- arbitrary[Option[Seq[io.k8s.api.core.v1.PodResourceClaim]]]
      hostUsers <- arbitrary[Option[Boolean]]
      runtimeClassName <- arbitrary[Option[String]]
      readinessGates <- arbitrary[Option[Seq[io.k8s.api.core.v1.PodReadinessGate]]]
      activeDeadlineSeconds <- arbitrary[Option[Long]]
      hostNetwork <- arbitrary[Option[Boolean]]
      securityContext <- arbitrary[Option[io.k8s.api.core.v1.PodSecurityContext]]
    } yield io.k8s.api.core.v1.PodSpec(
      containers = containers,
      schedulingGates = schedulingGates,
      priority = priority,
      hostIPC = hostIPC,
      serviceAccount = serviceAccount,
      schedulerName = schedulerName,
      hostname = hostname,
      imagePullSecrets = imagePullSecrets,
      affinity = affinity,
      os = os,
      nodeName = nodeName,
      ephemeralContainers = ephemeralContainers,
      initContainers = initContainers,
      shareProcessNamespace = shareProcessNamespace,
      setHostnameAsFQDN = setHostnameAsFQDN,
      enableServiceLinks = enableServiceLinks,
      preemptionPolicy = preemptionPolicy,
      dnsPolicy = dnsPolicy,
      volumes = volumes,
      hostAliases = hostAliases,
      subdomain = subdomain,
      topologySpreadConstraints = topologySpreadConstraints,
      overhead = overhead,
      tolerations = tolerations,
      automountServiceAccountToken = automountServiceAccountToken,
      nodeSelector = nodeSelector,
      hostPID = hostPID,
      terminationGracePeriodSeconds = terminationGracePeriodSeconds,
      dnsConfig = dnsConfig,
      priorityClassName = priorityClassName,
      serviceAccountName = serviceAccountName,
      restartPolicy = restartPolicy,
      resourceClaims = resourceClaims,
      hostUsers = hostUsers,
      runtimeClassName = runtimeClassName,
      readinessGates = readinessGates,
      activeDeadlineSeconds = activeDeadlineSeconds,
      hostNetwork = hostNetwork,
      securityContext = securityContext
    ))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1CertificateSigningRequestSpec: Arbitrary[io.k8s.api.certificates.v1.CertificateSigningRequestSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1.CertificateSigningRequestSpec(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DeploymentStatus: Arbitrary[io.k8s.api.apps.v1.DeploymentStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DeploymentStatus(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DeploymentStrategy: Arbitrary[io.k8s.api.apps.v1.DeploymentStrategy] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DeploymentStrategy(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3LimitedPriorityLevelConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1beta3.LimitedPriorityLevelConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.LimitedPriorityLevelConfiguration(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1VolumeMount: Arbitrary[io.k8s.api.core.v1.VolumeMount] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.VolumeMount(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSetUpdateStrategy: Arbitrary[io.k8s.api.apps.v1.StatefulSetUpdateStrategy] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSetUpdateStrategy(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1TopologySpreadConstraint: Arbitrary[io.k8s.api.core.v1.TopologySpreadConstraint] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.TopologySpreadConstraint(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1beta1SelfSubjectReviewStatus: Arbitrary[io.k8s.api.authentication.v1beta1.SelfSubjectReviewStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1beta1.SelfSubjectReviewStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1DownwardAPIVolumeFile: Arbitrary[io.k8s.api.core.v1.DownwardAPIVolumeFile] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.DownwardAPIVolumeFile(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1StorageClass: Arbitrary[io.k8s.api.storage.v1.StorageClass] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.StorageClass(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3QueuingConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1beta3.QueuingConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.QueuingConfiguration(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SelfSubjectRulesReviewSpec: Arbitrary[io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SelfSubjectRulesReviewSpec(_)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1OwnerReference: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeClaimCondition: Arbitrary[io.k8s.api.core.v1.PersistentVolumeClaimCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeClaimCondition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1DownwardAPIProjection: Arbitrary[io.k8s.api.core.v1.DownwardAPIProjection] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.DownwardAPIProjection(_)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1StatefulSetCondition: Arbitrary[io.k8s.api.apps.v1.StatefulSetCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.StatefulSetCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeAddress: Arbitrary[io.k8s.api.core.v1.NodeAddress] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeAddress(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PortworxVolumeSource: Arbitrary[io.k8s.api.core.v1.PortworxVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PortworxVolumeSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1TypedObjectReference: Arbitrary[io.k8s.api.core.v1.TypedObjectReference] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.TypedObjectReference(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeStatus: Arbitrary[io.k8s.api.core.v1.PersistentVolumeStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeStatus(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeCondition: Arbitrary[io.k8s.api.core.v1.NodeCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeCondition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2MetricStatus: Arbitrary[io.k8s.api.autoscaling.v2.MetricStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.MetricStatus(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1ExemptPriorityLevelConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1.ExemptPriorityLevelConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.ExemptPriorityLevelConfiguration(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1VolumeNodeAffinity: Arbitrary[io.k8s.api.core.v1.VolumeNodeAffinity] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.VolumeNodeAffinity(_)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1DaemonSetList: Arbitrary[io.k8s.api.apps.v1.DaemonSetList] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.DaemonSetList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SecretReference: Arbitrary[io.k8s.api.core.v1.SecretReference] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SecretReference(_, _)))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1alpha1ClusterTrustBundleSpec: Arbitrary[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1alpha1.ClusterTrustBundleSpec(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1Variable: Arbitrary[io.k8s.api.admissionregistration.v1beta1.Variable] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.Variable(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Event: Arbitrary[io.k8s.api.core.v1.Event] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Event(_, _, _, _, _, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ReplicationControllerSpec: Arbitrary[io.k8s.api.core.v1.ReplicationControllerSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ReplicationControllerSpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1ReplicaSet: Arbitrary[io.k8s.api.apps.v1.ReplicaSet] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.ReplicaSet(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1LocalSubjectAccessReview: Arbitrary[io.k8s.api.authorization.v1.LocalSubjectAccessReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.LocalSubjectAccessReview(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1alpha1ClusterTrustBundleList: Arbitrary[io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1alpha1.ClusterTrustBundleList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1FlexVolumeSource: Arbitrary[io.k8s.api.core.v1.FlexVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.FlexVolumeSource(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1alpha1ServiceCIDRSpec: Arbitrary[io.k8s.api.networking.v1alpha1.ServiceCIDRSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1alpha1.ServiceCIDRSpec(_)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1ClusterRoleBindingList: Arbitrary[io.k8s.api.rbac.v1.ClusterRoleBindingList] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.ClusterRoleBindingList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1ControllerRevisionList: Arbitrary[io.k8s.api.apps.v1.ControllerRevisionList] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.ControllerRevisionList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSINodeDriver: Arbitrary[io.k8s.api.storage.v1.CSINodeDriver] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSINodeDriver(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Probe: Arbitrary[io.k8s.api.core.v1.Probe] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Probe(_, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EnvVar: Arbitrary[io.k8s.api.core.v1.EnvVar] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EnvVar(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1AWSElasticBlockStoreVolumeSource: Arbitrary[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1VolumeDevice: Arbitrary[io.k8s.api.core.v1.VolumeDevice] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.VolumeDevice(_, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1TokenReview: Arbitrary[io.k8s.api.authentication.v1.TokenReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.TokenReview(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EventSeries: Arbitrary[io.k8s.api.core.v1.EventSeries] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EventSeries(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1ServiceAccountSubject: Arbitrary[io.k8s.api.flowcontrol.v1.ServiceAccountSubject] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.ServiceAccountSubject(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SELinuxOptions: Arbitrary[io.k8s.api.core.v1.SELinuxOptions] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SELinuxOptions(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionNames: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1StatusDetails: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.StatusDetails(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1ServiceBackendPort: Arbitrary[io.k8s.api.networking.v1.ServiceBackendPort] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.ServiceBackendPort(_, _)))
  implicit lazy val arbitrary_io_k8s_api_policy_v1PodDisruptionBudgetList: Arbitrary[io.k8s.api.policy.v1.PodDisruptionBudgetList] =  Arbitrary(Gen.resultOf(io.k8s.api.policy.v1.PodDisruptionBudgetList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1Deployment: Arbitrary[io.k8s.api.apps.v1.Deployment] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.Deployment(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1SelfSubjectReviewStatus: Arbitrary[io.k8s.api.authentication.v1.SelfSubjectReviewStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.SelfSubjectReviewStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeDaemonEndpoints: Arbitrary[io.k8s.api.core.v1.NodeDaemonEndpoints] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeDaemonEndpoints(_)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1TokenRequestSpec: Arbitrary[io.k8s.api.authentication.v1.TokenRequestSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1.TokenRequestSpec(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1SubjectAccessReviewSpec: Arbitrary[io.k8s.api.authorization.v1.SubjectAccessReviewSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.SubjectAccessReviewSpec(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EndpointSubset: Arbitrary[io.k8s.api.core.v1.EndpointSubset] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EndpointSubset(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ServiceList: Arbitrary[io.k8s.api.core.v1.ServiceList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ServiceList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeSpec: Arbitrary[io.k8s.api.core.v1.NodeSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeSpec(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1LimitedPriorityLevelConfiguration: Arbitrary[io.k8s.api.flowcontrol.v1.LimitedPriorityLevelConfiguration] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.LimitedPriorityLevelConfiguration(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ConfigMap: Arbitrary[io.k8s.api.core.v1.ConfigMap] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ConfigMap(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_versionInfo: Arbitrary[io.k8s.apimachinery.pkg.version.Info] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.version.Info(_, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2PodsMetricSource: Arbitrary[io.k8s.api.autoscaling.v2.PodsMetricSource] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.PodsMetricSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerImage: Arbitrary[io.k8s.api.core.v1.ContainerImage] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerImage(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ConfigMapProjection: Arbitrary[io.k8s.api.core.v1.ConfigMapProjection] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ConfigMapProjection(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeClaimVolumeSource: Arbitrary[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ExecAction: Arbitrary[io.k8s.api.core.v1.ExecAction] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ExecAction(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeList: Arbitrary[io.k8s.api.core.v1.NodeList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_node_v1Scheduling: Arbitrary[io.k8s.api.node.v1.Scheduling] =  Arbitrary(Gen.resultOf(io.k8s.api.node.v1.Scheduling(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1QuobyteVolumeSource: Arbitrary[io.k8s.api.core.v1.QuobyteVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.QuobyteVolumeSource(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceSubresourceScale: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimParametersReference: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimParametersReference(_, _, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceColumnDefinition: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1APIGroup: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ModifyVolumeStatus: Arbitrary[io.k8s.api.core.v1.ModifyVolumeStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ModifyVolumeStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1GlusterfsPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.GlusterfsPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.GlusterfsPersistentVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LoadBalancerStatus: Arbitrary[io.k8s.api.core.v1.LoadBalancerStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LoadBalancerStatus(_)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ComponentStatusList: Arbitrary[io.k8s.api.core.v1.ComponentStatusList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ComponentStatusList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1CronJobSpec: Arbitrary[io.k8s.api.batch.v1.CronJobSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.CronJobSpec(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authorization_v1NonResourceAttributes: Arbitrary[io.k8s.api.authorization.v1.NonResourceAttributes] =  Arbitrary(Gen.resultOf(io.k8s.api.authorization.v1.NonResourceAttributes(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1HTTPGetAction: Arbitrary[io.k8s.api.core.v1.HTTPGetAction] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.HTTPGetAction(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1TopologySelectorLabelRequirement: Arbitrary[io.k8s.api.core.v1.TopologySelectorLabelRequirement] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.TopologySelectorLabelRequirement(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1LocalVolumeSource: Arbitrary[io.k8s.api.core.v1.LocalVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.LocalVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressClassParametersReference: Arbitrary[io.k8s.api.networking.v1.IngressClassParametersReference] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressClassParametersReference(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1RBDPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.RBDPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.RBDPersistentVolumeSource(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1ObjectMeta: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta(_, _, _, _, _, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ResourceQuotaList: Arbitrary[io.k8s.api.core.v1.ResourceQuotaList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ResourceQuotaList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3FlowSchema: Arbitrary[io.k8s.api.flowcontrol.v1beta3.FlowSchema] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.FlowSchema(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ValidatingAdmissionPolicySpec: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicySpec] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicySpec(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ISCSIPersistentVolumeSource: Arbitrary[io.k8s.api.core.v1.ISCSIPersistentVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ISCSIPersistentVolumeSource(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1VolumeAttachment: Arbitrary[io.k8s.api.storage.v1.VolumeAttachment] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.VolumeAttachment(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ServicePort: Arbitrary[io.k8s.api.core.v1.ServicePort] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ServicePort(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ClientIPConfig: Arbitrary[io.k8s.api.core.v1.ClientIPConfig] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ClientIPConfig(_)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1UncountedTerminatedPods: Arbitrary[io.k8s.api.batch.v1.UncountedTerminatedPods] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.UncountedTerminatedPods(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1NetworkPolicySpec: Arbitrary[io.k8s.api.networking.v1.NetworkPolicySpec] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.NetworkPolicySpec(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SecretKeySelector: Arbitrary[io.k8s.api.core.v1.SecretKeySelector] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SecretKeySelector(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Node: Arbitrary[io.k8s.api.core.v1.Node] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Node(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1ReplicaSetStatus: Arbitrary[io.k8s.api.apps.v1.ReplicaSetStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.ReplicaSetStatus(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1RoleBindingList: Arbitrary[io.k8s.api.rbac.v1.RoleBindingList] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.RoleBindingList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1SecretVolumeSource: Arbitrary[io.k8s.api.core.v1.SecretVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.SecretVolumeSource(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_certificates_v1CertificateSigningRequest: Arbitrary[io.k8s.api.certificates.v1.CertificateSigningRequest] =  Arbitrary(Gen.resultOf(io.k8s.api.certificates.v1.CertificateSigningRequest(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HorizontalPodAutoscaler: Arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodOS: Arbitrary[io.k8s.api.core.v1.PodOS] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodOS(_)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceValidation: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation(_)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimTemplateList: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimTemplateList] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimTemplateList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_rbac_v1Role: Arbitrary[io.k8s.api.rbac.v1.Role] =  Arbitrary(Gen.resultOf(io.k8s.api.rbac.v1.Role(_, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1ManagedFieldsEntry: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1HostAlias: Arbitrary[io.k8s.api.core.v1.HostAlias] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.HostAlias(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1HTTPIngressRuleValue: Arbitrary[io.k8s.api.networking.v1.HTTPIngressRuleValue] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.HTTPIngressRuleValue(_)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ValidatingAdmissionPolicy: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicy] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicy(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodAntiAffinity: Arbitrary[io.k8s.api.core.v1.PodAntiAffinity] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodAntiAffinity(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Affinity: Arbitrary[io.k8s.api.core.v1.Affinity] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Affinity(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ContainerResourceMetricStatus: Arbitrary[io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ContainerResourceMetricStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_authentication_v1alpha1SelfSubjectReview: Arbitrary[io.k8s.api.authentication.v1alpha1.SelfSubjectReview] =  Arbitrary(Gen.resultOf(io.k8s.api.authentication.v1alpha1.SelfSubjectReview(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1NonResourcePolicyRule: Arbitrary[io.k8s.api.flowcontrol.v1.NonResourcePolicyRule] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1.NonResourcePolicyRule(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1AzureDiskVolumeSource: Arbitrary[io.k8s.api.core.v1.AzureDiskVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.AzureDiskVolumeSource(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NFSVolumeSource: Arbitrary[io.k8s.api.core.v1.NFSVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NFSVolumeSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressBackend: Arbitrary[io.k8s.api.networking.v1.IngressBackend] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressBackend(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1ReplicaSetCondition: Arbitrary[io.k8s.api.apps.v1.ReplicaSetCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.ReplicaSetCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerResizePolicy: Arbitrary[io.k8s.api.core.v1.ContainerResizePolicy] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerResizePolicy(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apps_v1ReplicaSetList: Arbitrary[io.k8s.api.apps.v1.ReplicaSetList] =  Arbitrary(Gen.resultOf(io.k8s.api.apps.v1.ReplicaSetList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1Namespace: Arbitrary[io.k8s.api.core.v1.Namespace] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.Namespace(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ReplicationControllerList: Arbitrary[io.k8s.api.core.v1.ReplicationControllerList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ReplicationControllerList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ValidatingAdmissionPolicyStatus: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ValidatingAdmissionPolicyStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1CSIStorageCapacityList: Arbitrary[io.k8s.api.storage.v1.CSIStorageCapacityList] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.CSIStorageCapacityList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EphemeralContainer: Arbitrary[io.k8s.api.core.v1.EphemeralContainer] =  Arbitrary(for {
      name <- arbitrary[String]
      readinessProbe <- arbitrary[Option[io.k8s.api.core.v1.Probe]]
      livenessProbe <- arbitrary[Option[io.k8s.api.core.v1.Probe]]
      lifecycle <- arbitrary[Option[io.k8s.api.core.v1.Lifecycle]]
      image <- arbitrary[Option[String]]
      resizePolicy <- arbitrary[Option[Seq[io.k8s.api.core.v1.ContainerResizePolicy]]]
      stdinOnce <- arbitrary[Option[Boolean]]
      ports <- arbitrary[Option[Seq[io.k8s.api.core.v1.ContainerPort]]]
      startupProbe <- arbitrary[Option[io.k8s.api.core.v1.Probe]]
      command <- arbitrary[Option[Seq[String]]]
      terminationMessagePolicy <- arbitrary[Option[String]]
      targetContainerName <- arbitrary[Option[String]]
      restartPolicy <- arbitrary[Option[String]]
      stdin <- arbitrary[Option[Boolean]]
      terminationMessagePath <- arbitrary[Option[String]]
      resources <- arbitrary[Option[io.k8s.api.core.v1.ResourceRequirements]]
      envFrom <- arbitrary[Option[Seq[io.k8s.api.core.v1.EnvFromSource]]]
      volumeDevices <- arbitrary[Option[Seq[io.k8s.api.core.v1.VolumeDevice]]]
      args <- arbitrary[Option[Seq[String]]]
      tty <- arbitrary[Option[Boolean]]
      imagePullPolicy <- arbitrary[Option[String]]
      workingDir <- arbitrary[Option[String]]
      volumeMounts <- arbitrary[Option[Seq[io.k8s.api.core.v1.VolumeMount]]]
      env <- arbitrary[Option[Seq[io.k8s.api.core.v1.EnvVar]]]
      securityContext <- arbitrary[Option[io.k8s.api.core.v1.SecurityContext]]
    } yield io.k8s.api.core.v1.EphemeralContainer(
      name = name,
      readinessProbe = readinessProbe,
      livenessProbe = livenessProbe,
      lifecycle = lifecycle,
      image = image,
      resizePolicy = resizePolicy,
      stdinOnce = stdinOnce,
      ports = ports,
      startupProbe = startupProbe,
      command = command,
      terminationMessagePolicy = terminationMessagePolicy,
      targetContainerName = targetContainerName,
      restartPolicy = restartPolicy,
      stdin = stdin,
      terminationMessagePath = terminationMessagePath,
      resources = resources,
      envFrom = envFrom,
      volumeDevices = volumeDevices,
      args = args,
      tty = tty,
      imagePullPolicy = imagePullPolicy,
      workingDir = workingDir,
      volumeMounts = volumeMounts,
      env = env,
      securityContext = securityContext
    ))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceSubresources: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodDNSConfigOption: Arbitrary[io.k8s.api.core.v1.PodDNSConfigOption] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodDNSConfigOption(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NodeConfigStatus: Arbitrary[io.k8s.api.core.v1.NodeConfigStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NodeConfigStatus(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_apimachinery_pkg_apis_meta_v1LabelSelectorRequirement: Arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement] =  Arbitrary(Gen.resultOf(io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ObjectMetricStatus: Arbitrary[io.k8s.api.autoscaling.v2.ObjectMetricStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ObjectMetricStatus(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ProjectedVolumeSource: Arbitrary[io.k8s.api.core.v1.ProjectedVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ProjectedVolumeSource(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1IngressTLS: Arbitrary[io.k8s.api.networking.v1.IngressTLS] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.IngressTLS(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1NetworkPolicyEgressRule: Arbitrary[io.k8s.api.networking.v1.NetworkPolicyEgressRule] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.NetworkPolicyEgressRule(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1RBDVolumeSource: Arbitrary[io.k8s.api.core.v1.RBDVolumeSource] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.RBDVolumeSource(_, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ExpressionWarning: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ExpressionWarning] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ExpressionWarning(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1VolumeResourceRequirements: Arbitrary[io.k8s.api.core.v1.VolumeResourceRequirements] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.VolumeResourceRequirements(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClassList: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClassList] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClassList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1NamespaceList: Arbitrary[io.k8s.api.core.v1.NamespaceList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.NamespaceList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3FlowSchemaList: Arbitrary[io.k8s.api.flowcontrol.v1beta3.FlowSchemaList] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.FlowSchemaList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_apiserverinternal_v1alpha1StorageVersionCondition: Arbitrary[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.apiserverinternal.v1alpha1.StorageVersionCondition(_, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1alpha1ParamKind: Arbitrary[io.k8s.api.admissionregistration.v1alpha1.ParamKind] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1alpha1.ParamKind(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1VolumeAttachmentSpec: Arbitrary[io.k8s.api.storage.v1.VolumeAttachmentSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.VolumeAttachmentSpec(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeClaimSpec: Arbitrary[io.k8s.api.core.v1.PersistentVolumeClaimSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeClaimSpec(_, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimList: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimList] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_policy_v1PodDisruptionBudgetStatus: Arbitrary[io.k8s.api.policy.v1.PodDisruptionBudgetStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.policy.v1.PodDisruptionBudgetStatus(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1MatchCondition: Arbitrary[io.k8s.api.admissionregistration.v1.MatchCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1.MatchCondition(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ConfigMapKeySelector: Arbitrary[io.k8s.api.core.v1.ConfigMapKeySelector] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ConfigMapKeySelector(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PodAffinity: Arbitrary[io.k8s.api.core.v1.PodAffinity] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PodAffinity(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3PolicyRulesWithSubjects: Arbitrary[io.k8s.api.flowcontrol.v1beta3.PolicyRulesWithSubjects] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.PolicyRulesWithSubjects(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1NetworkPolicyList: Arbitrary[io.k8s.api.networking.v1.NetworkPolicyList] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.NetworkPolicyList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_batch_v1JobStatus: Arbitrary[io.k8s.api.batch.v1.JobStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.batch.v1.JobStatus(_, _, _, _, _, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_admissionregistration_v1beta1ParamKind: Arbitrary[io.k8s.api.admissionregistration.v1beta1.ParamKind] =  Arbitrary(Gen.resultOf(io.k8s.api.admissionregistration.v1beta1.ParamKind(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1EndpointAddress: Arbitrary[io.k8s.api.core.v1.EndpointAddress] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.EndpointAddress(_, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_scheduling_v1PriorityClass: Arbitrary[io.k8s.api.scheduling.v1.PriorityClass] =  Arbitrary(Gen.resultOf(io.k8s.api.scheduling.v1.PriorityClass(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2HorizontalPodAutoscalerSpec: Arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerSpec(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_discovery_v1EndpointSliceList: Arbitrary[io.k8s.api.discovery.v1.EndpointSliceList] =  Arbitrary(Gen.resultOf(io.k8s.api.discovery.v1.EndpointSliceList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_resource_v1alpha2ResourceClaimTemplate: Arbitrary[io.k8s.api.resource.v1alpha2.ResourceClaimTemplate] =  Arbitrary(Gen.resultOf(io.k8s.api.resource.v1alpha2.ResourceClaimTemplate(_, _)))
  implicit lazy val arbitrary_io_k8s_api_flowcontrol_v1beta3PriorityLevelConfigurationCondition: Arbitrary[io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition] =  Arbitrary(Gen.resultOf(io.k8s.api.flowcontrol.v1beta3.PriorityLevelConfigurationCondition(_, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeClaimTemplate: Arbitrary[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeClaimTemplate(_, _)))
  implicit lazy val arbitrary_io_k8s_api_storage_v1StorageClassList: Arbitrary[io.k8s.api.storage.v1.StorageClassList] =  Arbitrary(Gen.resultOf(io.k8s.api.storage.v1.StorageClassList(_, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v2ContainerResourceMetricSource: Arbitrary[io.k8s.api.autoscaling.v2.ContainerResourceMetricSource] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v2.ContainerResourceMetricSource(_, _, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1ContainerStateTerminated: Arbitrary[io.k8s.api.core.v1.ContainerStateTerminated] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.ContainerStateTerminated(_, _, _, _, _, _, _)))
  implicit lazy val arbitrary_io_k8s_api_autoscaling_v1ScaleStatus: Arbitrary[io.k8s.api.autoscaling.v1.ScaleStatus] =  Arbitrary(Gen.resultOf(io.k8s.api.autoscaling.v1.ScaleStatus(_, _)))
  implicit lazy val arbitrary_io_k8s_api_networking_v1NetworkPolicy: Arbitrary[io.k8s.api.networking.v1.NetworkPolicy] =  Arbitrary(Gen.resultOf(io.k8s.api.networking.v1.NetworkPolicy(_, _)))
  implicit lazy val arbitrary_io_k8s_api_core_v1PersistentVolumeClaimList: Arbitrary[io.k8s.api.core.v1.PersistentVolumeClaimList] =  Arbitrary(Gen.resultOf(io.k8s.api.core.v1.PersistentVolumeClaimList(_, _)))
  implicit lazy val arbitrary_io_k8s_apiextensions_apiserver_pkg_apis_apiextensions_v1CustomResourceDefinitionVersion: Arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion] =  Arbitrary(Gen.resultOf(io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion(_, _, _, _, _, _, _, _)))
}

