package dev.hnaderi.k8s
package scalacheck

import org.scalacheck.Arbitrary
import org.scalacheck.Arbitrary.arbitrary
import org.scalacheck.Gen

private[scalacheck] trait KObjectGenerators { self : NonPrimitiveGenerators with PrimitiveGenerators =>
  implicit val arbitraryKObjects : Arbitrary[KObject] = Arbitrary(
    Gen.oneOf(
      arbitrary[io.k8s.api.core.v1.LimitRange],
      arbitrary[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler],
      arbitrary[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList],
      arbitrary[io.k8s.api.storage.v1beta1.CSIStorageCapacity],
      arbitrary[io.k8s.api.authorization.v1.SubjectAccessReview],
      arbitrary[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList],
      arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIVersions],
      arbitrary[io.k8s.api.networking.v1.IngressClass],
      arbitrary[io.k8s.api.storage.v1.CSINodeList],
      arbitrary[io.k8s.api.core.v1.ConfigMapList],
      arbitrary[io.k8s.api.batch.v1.CronJobList],
      arbitrary[io.k8s.api.core.v1.SecretList],
      arbitrary[io.k8s.api.discovery.v1.EndpointSlice],
      arbitrary[io.k8s.api.authorization.v1.SelfSubjectRulesReview],
      arbitrary[io.k8s.api.rbac.v1.ClusterRoleList],
      arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition],
      arbitrary[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration],
      arbitrary[io.k8s.api.networking.v1alpha1.ClusterCIDRList],
      arbitrary[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfiguration],
      arbitrary[io.k8s.api.admissionregistration.v1.ValidatingWebhookConfigurationList],
      arbitrary[io.k8s.api.apps.v1.StatefulSetList],
      arbitrary[io.k8s.api.core.v1.ServiceAccount],
      arbitrary[io.k8s.api.core.v1.PersistentVolume],
      arbitrary[io.k8s.api.coordination.v1.Lease],
      arbitrary[io.k8s.api.rbac.v1.ClusterRoleBinding],
      arbitrary[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion],
      arbitrary[io.k8s.api.batch.v1.Job],
      arbitrary[io.k8s.api.core.v1.PodList],
      arbitrary[io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList],
      arbitrary[io.k8s.api.core.v1.Pod],
      arbitrary[io.k8s.api.core.v1.ComponentStatus],
      arbitrary[io.k8s.api.coordination.v1.LeaseList],
      arbitrary[io.k8s.api.events.v1.EventList],
      arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService],
      arbitrary[io.k8s.api.networking.v1alpha1.ClusterCIDR],
      arbitrary[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfigurationList],
      arbitrary[io.k8s.api.autoscaling.v1.Scale],
      arbitrary[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler],
      arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.Status],
      arbitrary[io.k8s.api.rbac.v1.RoleList],
      arbitrary[io.k8s.api.core.v1.EventList],
      arbitrary[io.k8s.api.apps.v1.ControllerRevision],
      arbitrary[io.k8s.api.core.v1.PodTemplateList],
      arbitrary[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration],
      arbitrary[io.k8s.api.apps.v1.StatefulSet],
      arbitrary[io.k8s.api.core.v1.ServiceAccountList],
      arbitrary[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList],
      arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList],
      arbitrary[io.k8s.api.core.v1.LimitRangeList],
      arbitrary[io.k8s.api.policy.v1.PodDisruptionBudget],
      arbitrary[io.k8s.api.networking.v1.Ingress],
      arbitrary[io.k8s.api.networking.v1.IngressClassList],
      arbitrary[io.k8s.api.certificates.v1.CertificateSigningRequestList],
      arbitrary[io.k8s.api.flowcontrol.v1beta2.FlowSchemaList],
      arbitrary[io.k8s.api.storage.v1.CSIStorageCapacity],
      arbitrary[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList],
      arbitrary[io.k8s.api.events.v1.Event],
      arbitrary[io.k8s.api.apps.v1.DaemonSet],
      arbitrary[io.k8s.api.authorization.v1.SelfSubjectAccessReview],
      arbitrary[io.k8s.api.batch.v1.JobList],
      arbitrary[io.k8s.api.rbac.v1.RoleBinding],
      arbitrary[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfigurationList],
      arbitrary[io.k8s.api.core.v1.Secret],
      arbitrary[io.k8s.api.core.v1.ResourceQuota],
      arbitrary[io.k8s.api.apps.v1.DeploymentList],
      arbitrary[io.k8s.api.storage.v1beta1.CSIStorageCapacityList],
      arbitrary[io.k8s.api.core.v1.Binding],
      arbitrary[io.k8s.api.batch.v1.CronJob],
      arbitrary[io.k8s.api.storage.v1.CSINode],
      arbitrary[io.k8s.api.storage.v1.CSIDriver],
      arbitrary[io.k8s.api.core.v1.EndpointsList],
      arbitrary[io.k8s.api.node.v1.RuntimeClassList],
      arbitrary[io.k8s.api.core.v1.ReplicationController],
      arbitrary[io.k8s.api.rbac.v1.ClusterRole],
      arbitrary[io.k8s.api.scheduling.v1.PriorityClassList],
      arbitrary[io.k8s.api.storage.v1.VolumeAttachmentList],
      arbitrary[io.k8s.api.authentication.v1.TokenRequest],
      arbitrary[io.k8s.api.core.v1.PersistentVolumeClaim],
      arbitrary[io.k8s.api.core.v1.PodTemplate],
      arbitrary[io.k8s.api.storage.v1.CSIDriverList],
      arbitrary[io.k8s.api.networking.v1.IngressList],
      arbitrary[io.k8s.api.policy.v1.Eviction],
      arbitrary[io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList],
      arbitrary[io.k8s.api.core.v1.Endpoints],
      arbitrary[io.k8s.api.core.v1.PersistentVolumeList],
      arbitrary[io.k8s.api.flowcontrol.v1beta1.FlowSchema],
      arbitrary[io.k8s.api.node.v1.RuntimeClass],
      arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroupList],
      arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerList],
      arbitrary[io.k8s.api.core.v1.Service],
      arbitrary[io.k8s.api.storage.v1.StorageClass],
      arbitrary[io.k8s.api.apps.v1.DaemonSetList],
      arbitrary[io.k8s.api.core.v1.Event],
      arbitrary[io.k8s.api.apps.v1.ReplicaSet],
      arbitrary[io.k8s.api.authorization.v1.LocalSubjectAccessReview],
      arbitrary[io.k8s.api.rbac.v1.ClusterRoleBindingList],
      arbitrary[io.k8s.api.apps.v1.ControllerRevisionList],
      arbitrary[io.k8s.api.flowcontrol.v1beta1.FlowSchemaList],
      arbitrary[io.k8s.api.authentication.v1.TokenReview],
      arbitrary[io.k8s.api.policy.v1.PodDisruptionBudgetList],
      arbitrary[io.k8s.api.apps.v1.Deployment],
      arbitrary[io.k8s.api.core.v1.ServiceList],
      arbitrary[io.k8s.api.core.v1.ConfigMap],
      arbitrary[io.k8s.api.core.v1.NodeList],
      arbitrary[io.k8s.apimachinery.pkg.apis.meta.v1.APIGroup],
      arbitrary[io.k8s.api.core.v1.ComponentStatusList],
      arbitrary[io.k8s.api.core.v1.ResourceQuotaList],
      arbitrary[io.k8s.api.storage.v1.VolumeAttachment],
      arbitrary[io.k8s.api.core.v1.Node],
      arbitrary[io.k8s.api.rbac.v1.RoleBindingList],
      arbitrary[io.k8s.api.certificates.v1.CertificateSigningRequest],
      arbitrary[io.k8s.api.autoscaling.v2.HorizontalPodAutoscaler],
      arbitrary[io.k8s.api.rbac.v1.Role],
      arbitrary[io.k8s.api.apps.v1.ReplicaSetList],
      arbitrary[io.k8s.api.core.v1.Namespace],
      arbitrary[io.k8s.api.core.v1.ReplicationControllerList],
      arbitrary[io.k8s.api.storage.v1.CSIStorageCapacityList],
      arbitrary[io.k8s.api.core.v1.NamespaceList],
      arbitrary[io.k8s.api.flowcontrol.v1beta2.FlowSchema],
      arbitrary[io.k8s.api.networking.v1.NetworkPolicyList],
      arbitrary[io.k8s.api.scheduling.v1.PriorityClass],
      arbitrary[io.k8s.api.discovery.v1.EndpointSliceList],
      arbitrary[io.k8s.api.storage.v1.StorageClassList],
      arbitrary[io.k8s.api.flowcontrol.v1beta1.PriorityLevelConfiguration],
      arbitrary[io.k8s.api.networking.v1.NetworkPolicy],
      arbitrary[io.k8s.api.core.v1.PersistentVolumeClaimList]
    )
  )
}

