package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1

import dev.hnaderi.k8s.utils._

/** APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification. */
final case class APIServiceSpec(
  versionPriority : Int,
  groupPriorityMinimum : Int,
  caBundle : Option[String] = None,
  service : Option[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference] = None,
  version : Option[String] = None,
  group : Option[String] = None,
  insecureSkipTLSVerify : Option[Boolean] = None
) {

  /** Returns a new data with versionPriority set to new value */
  def withVersionPriority(value: Int) : APIServiceSpec = copy(versionPriority = value)
  /** transforms versionPriority to result of function */
  def mapVersionPriority(f: Int => Int) : APIServiceSpec = copy(versionPriority = f(versionPriority))

  /** Returns a new data with groupPriorityMinimum set to new value */
  def withGroupPriorityMinimum(value: Int) : APIServiceSpec = copy(groupPriorityMinimum = value)
  /** transforms groupPriorityMinimum to result of function */
  def mapGroupPriorityMinimum(f: Int => Int) : APIServiceSpec = copy(groupPriorityMinimum = f(groupPriorityMinimum))

  /** Returns a new data with caBundle set to new value */
  def withCaBundle(value: String) : APIServiceSpec = copy(caBundle = Some(value))
  /** if caBundle has a value, transforms to the result of function*/
  def mapCaBundle(f: String => String) : APIServiceSpec = copy(caBundle = caBundle.map(f))

  /** Returns a new data with service set to new value */
  def withService(value: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference) : APIServiceSpec = copy(service = Some(value))
  /** if service has a value, transforms to the result of function*/
  def mapService(f: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference => io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference) : APIServiceSpec = copy(service = service.map(f))

  /** Returns a new data with version set to new value */
  def withVersion(value: String) : APIServiceSpec = copy(version = Some(value))
  /** if version has a value, transforms to the result of function*/
  def mapVersion(f: String => String) : APIServiceSpec = copy(version = version.map(f))

  /** Returns a new data with group set to new value */
  def withGroup(value: String) : APIServiceSpec = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: String => String) : APIServiceSpec = copy(group = group.map(f))

  /** Returns a new data with insecureSkipTLSVerify set to new value */
  def withInsecureSkipTLSVerify(value: Boolean) : APIServiceSpec = copy(insecureSkipTLSVerify = Some(value))
  /** if insecureSkipTLSVerify has a value, transforms to the result of function*/
  def mapInsecureSkipTLSVerify(f: Boolean => Boolean) : APIServiceSpec = copy(insecureSkipTLSVerify = insecureSkipTLSVerify.map(f))
}

object APIServiceSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec, T] = new Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec, T] {
        def apply(o: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("versionPriority", o.versionPriority)
            .write("groupPriorityMinimum", o.groupPriorityMinimum)
            .write("caBundle", o.caBundle)
            .write("service", o.service)
            .write("version", o.version)
            .write("group", o.group)
            .write("insecureSkipTLSVerify", o.insecureSkipTLSVerify)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, APIServiceSpec] = new Decoder[T, APIServiceSpec] {
      def apply(t: T): Either[String, APIServiceSpec] = for {
          obj <- ObjectReader(t)
          versionPriority <- obj.read[Int]("versionPriority")
          groupPriorityMinimum <- obj.read[Int]("groupPriorityMinimum")
          caBundle <- obj.readOpt[String]("caBundle")
          service <- obj.readOpt[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.ServiceReference]("service")
          version <- obj.readOpt[String]("version")
          group <- obj.readOpt[String]("group")
          insecureSkipTLSVerify <- obj.readOpt[Boolean]("insecureSkipTLSVerify")
      } yield APIServiceSpec (
          versionPriority = versionPriority,
          groupPriorityMinimum = groupPriorityMinimum,
          caBundle = caBundle,
          service = service,
          version = version,
          group = group,
          insecureSkipTLSVerify = insecureSkipTLSVerify
        )
    }
}

