package io.k8s.kube_aggregator.pkg.apis.apiregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** APIServiceList is a list of APIService objects. */
final case class APIServiceList(
  items : Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiregistration.k8s.io", "APIServiceList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService]) : APIServiceList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService*) : APIServiceList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService] => Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService]) : APIServiceList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : APIServiceList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : APIServiceList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = APIServiceList.encoder[T].apply(this)
}

object APIServiceList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList, T] = new Encoder[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList, T] {
        def apply(o: io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIServiceList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, APIServiceList] = new Decoder[T, APIServiceList] {
      def apply(t: T): Either[String, APIServiceList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.kube_aggregator.pkg.apis.apiregistration.v1.APIService]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield APIServiceList (
          items = items,
          metadata = metadata
        )
    }
}

