package io.k8s.apimachinery.pkg.version

import dev.hnaderi.k8s.utils._

/** Info contains versioning information. how we'll want to distribute that information. */
final case class Info(
  gitCommit : String,
  goVersion : String,
  compiler : String,
  gitVersion : String,
  gitTreeState : String,
  platform : String,
  buildDate : String,
  major : String,
  minor : String
) {

  /** Returns a new data with gitCommit set to new value */
  def withGitCommit(value: String) : Info = copy(gitCommit = value)
  /** transforms gitCommit to result of function */
  def mapGitCommit(f: String => String) : Info = copy(gitCommit = f(gitCommit))

  /** Returns a new data with goVersion set to new value */
  def withGoVersion(value: String) : Info = copy(goVersion = value)
  /** transforms goVersion to result of function */
  def mapGoVersion(f: String => String) : Info = copy(goVersion = f(goVersion))

  /** Returns a new data with compiler set to new value */
  def withCompiler(value: String) : Info = copy(compiler = value)
  /** transforms compiler to result of function */
  def mapCompiler(f: String => String) : Info = copy(compiler = f(compiler))

  /** Returns a new data with gitVersion set to new value */
  def withGitVersion(value: String) : Info = copy(gitVersion = value)
  /** transforms gitVersion to result of function */
  def mapGitVersion(f: String => String) : Info = copy(gitVersion = f(gitVersion))

  /** Returns a new data with gitTreeState set to new value */
  def withGitTreeState(value: String) : Info = copy(gitTreeState = value)
  /** transforms gitTreeState to result of function */
  def mapGitTreeState(f: String => String) : Info = copy(gitTreeState = f(gitTreeState))

  /** Returns a new data with platform set to new value */
  def withPlatform(value: String) : Info = copy(platform = value)
  /** transforms platform to result of function */
  def mapPlatform(f: String => String) : Info = copy(platform = f(platform))

  /** Returns a new data with buildDate set to new value */
  def withBuildDate(value: String) : Info = copy(buildDate = value)
  /** transforms buildDate to result of function */
  def mapBuildDate(f: String => String) : Info = copy(buildDate = f(buildDate))

  /** Returns a new data with major set to new value */
  def withMajor(value: String) : Info = copy(major = value)
  /** transforms major to result of function */
  def mapMajor(f: String => String) : Info = copy(major = f(major))

  /** Returns a new data with minor set to new value */
  def withMinor(value: String) : Info = copy(minor = value)
  /** transforms minor to result of function */
  def mapMinor(f: String => String) : Info = copy(minor = f(minor))
}

object Info {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.apimachinery.pkg.version.Info, T] = new Encoder[io.k8s.apimachinery.pkg.version.Info, T] {
        def apply(o: io.k8s.apimachinery.pkg.version.Info) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("gitCommit", o.gitCommit)
            .write("goVersion", o.goVersion)
            .write("compiler", o.compiler)
            .write("gitVersion", o.gitVersion)
            .write("gitTreeState", o.gitTreeState)
            .write("platform", o.platform)
            .write("buildDate", o.buildDate)
            .write("major", o.major)
            .write("minor", o.minor)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Info] = new Decoder[T, Info] {
      def apply(t: T): Either[String, Info] = for {
          obj <- ObjectReader(t)
          gitCommit <- obj.read[String]("gitCommit")
          goVersion <- obj.read[String]("goVersion")
          compiler <- obj.read[String]("compiler")
          gitVersion <- obj.read[String]("gitVersion")
          gitTreeState <- obj.read[String]("gitTreeState")
          platform <- obj.read[String]("platform")
          buildDate <- obj.read[String]("buildDate")
          major <- obj.read[String]("major")
          minor <- obj.read[String]("minor")
      } yield Info (
          gitCommit = gitCommit,
          goVersion = goVersion,
          compiler = compiler,
          gitVersion = gitVersion,
          gitTreeState = gitTreeState,
          platform = platform,
          buildDate = buildDate,
          major = major,
          minor = minor
        )
    }
}

