package io.k8s.api.storage.v1

import dev.hnaderi.k8s.utils._

/** VolumeAttachmentSource represents a volume that should be attached. Right now only PersistenVolumes can be attached via external attacher, in future we may allow also inline volumes in pods. Exactly one member can be set. */
final case class VolumeAttachmentSource(
  inlineVolumeSpec : Option[io.k8s.api.core.v1.PersistentVolumeSpec] = None,
  persistentVolumeName : Option[String] = None
) {

  /** Returns a new data with inlineVolumeSpec set to new value */
  def withInlineVolumeSpec(value: io.k8s.api.core.v1.PersistentVolumeSpec) : VolumeAttachmentSource = copy(inlineVolumeSpec = Some(value))
  /** if inlineVolumeSpec has a value, transforms to the result of function*/
  def mapInlineVolumeSpec(f: io.k8s.api.core.v1.PersistentVolumeSpec => io.k8s.api.core.v1.PersistentVolumeSpec) : VolumeAttachmentSource = copy(inlineVolumeSpec = inlineVolumeSpec.map(f))

  /** Returns a new data with persistentVolumeName set to new value */
  def withPersistentVolumeName(value: String) : VolumeAttachmentSource = copy(persistentVolumeName = Some(value))
  /** if persistentVolumeName has a value, transforms to the result of function*/
  def mapPersistentVolumeName(f: String => String) : VolumeAttachmentSource = copy(persistentVolumeName = persistentVolumeName.map(f))
}

object VolumeAttachmentSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.storage.v1.VolumeAttachmentSource, T] = new Encoder[io.k8s.api.storage.v1.VolumeAttachmentSource, T] {
        def apply(o: io.k8s.api.storage.v1.VolumeAttachmentSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("inlineVolumeSpec", o.inlineVolumeSpec)
            .write("persistentVolumeName", o.persistentVolumeName)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, VolumeAttachmentSource] = new Decoder[T, VolumeAttachmentSource] {
      def apply(t: T): Either[String, VolumeAttachmentSource] = for {
          obj <- ObjectReader(t)
          inlineVolumeSpec <- obj.readOpt[io.k8s.api.core.v1.PersistentVolumeSpec]("inlineVolumeSpec")
          persistentVolumeName <- obj.readOpt[String]("persistentVolumeName")
      } yield VolumeAttachmentSource (
          inlineVolumeSpec = inlineVolumeSpec,
          persistentVolumeName = persistentVolumeName
        )
    }
}

