package io.k8s.api.storage.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CSIDriverList is a collection of CSIDriver objects. */
final case class CSIDriverList(
  items : Seq[io.k8s.api.storage.v1.CSIDriver],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSIDriverList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.storage.v1.CSIDriver]) : CSIDriverList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.storage.v1.CSIDriver*) : CSIDriverList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.storage.v1.CSIDriver] => Seq[io.k8s.api.storage.v1.CSIDriver]) : CSIDriverList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSIDriverList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CSIDriverList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CSIDriverList.encoder[T].apply(this)
}

object CSIDriverList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.storage.v1.CSIDriverList, T] = new Encoder[io.k8s.api.storage.v1.CSIDriverList, T] {
        def apply(o: io.k8s.api.storage.v1.CSIDriverList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, CSIDriverList] = new Decoder[T, CSIDriverList] {
      def apply(t: T): Either[String, CSIDriverList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.storage.v1.CSIDriver]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield CSIDriverList (
          items = items,
          metadata = metadata
        )
    }
}

