package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ClusterRoleList is a collection of ClusterRoles */
final case class ClusterRoleList(
  items : Seq[io.k8s.api.rbac.v1.ClusterRole],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRoleList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.rbac.v1.ClusterRole]) : ClusterRoleList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.rbac.v1.ClusterRole*) : ClusterRoleList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.rbac.v1.ClusterRole] => Seq[io.k8s.api.rbac.v1.ClusterRole]) : ClusterRoleList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterRoleList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ClusterRoleList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ClusterRoleList.encoder[T].apply(this)
}

object ClusterRoleList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.rbac.v1.ClusterRoleList, T] = new Encoder[io.k8s.api.rbac.v1.ClusterRoleList, T] {
        def apply(o: io.k8s.api.rbac.v1.ClusterRoleList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ClusterRoleList] = new Decoder[T, ClusterRoleList] {
      def apply(t: T): Either[String, ClusterRoleList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.rbac.v1.ClusterRole]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ClusterRoleList (
          items = items,
          metadata = metadata
        )
    }
}

