package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressStatus describe the current state of the Ingress. */
final case class IngressStatus(
  loadBalancer : Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
) {

  /** Returns a new data with loadBalancer set to new value */
  def withLoadBalancer(value: io.k8s.api.core.v1.LoadBalancerStatus) : IngressStatus = copy(loadBalancer = Some(value))
  /** if loadBalancer has a value, transforms to the result of function*/
  def mapLoadBalancer(f: io.k8s.api.core.v1.LoadBalancerStatus => io.k8s.api.core.v1.LoadBalancerStatus) : IngressStatus = copy(loadBalancer = loadBalancer.map(f))
}

object IngressStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.IngressStatus, T] = new Encoder[io.k8s.api.networking.v1.IngressStatus, T] {
        def apply(o: io.k8s.api.networking.v1.IngressStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("loadBalancer", o.loadBalancer)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, IngressStatus] = new Decoder[T, IngressStatus] {
      def apply(t: T): Either[String, IngressStatus] = for {
          obj <- ObjectReader(t)
          loadBalancer <- obj.readOpt[io.k8s.api.core.v1.LoadBalancerStatus]("loadBalancer")
      } yield IngressStatus (
          loadBalancer = loadBalancer
        )
    }
}

