package io.k8s.api.networking.v1

import dev.hnaderi.k8s.utils._

/** IngressClassSpec provides information about the class of an Ingress. */
final case class IngressClassSpec(
  controller : Option[String] = None,
  parameters : Option[io.k8s.api.networking.v1.IngressClassParametersReference] = None
) {

  /** Returns a new data with controller set to new value */
  def withController(value: String) : IngressClassSpec = copy(controller = Some(value))
  /** if controller has a value, transforms to the result of function*/
  def mapController(f: String => String) : IngressClassSpec = copy(controller = controller.map(f))

  /** Returns a new data with parameters set to new value */
  def withParameters(value: io.k8s.api.networking.v1.IngressClassParametersReference) : IngressClassSpec = copy(parameters = Some(value))
  /** if parameters has a value, transforms to the result of function*/
  def mapParameters(f: io.k8s.api.networking.v1.IngressClassParametersReference => io.k8s.api.networking.v1.IngressClassParametersReference) : IngressClassSpec = copy(parameters = parameters.map(f))
}

object IngressClassSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.networking.v1.IngressClassSpec, T] = new Encoder[io.k8s.api.networking.v1.IngressClassSpec, T] {
        def apply(o: io.k8s.api.networking.v1.IngressClassSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("controller", o.controller)
            .write("parameters", o.parameters)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, IngressClassSpec] = new Decoder[T, IngressClassSpec] {
      def apply(t: T): Either[String, IngressClassSpec] = for {
          obj <- ObjectReader(t)
          controller <- obj.readOpt[String]("controller")
          parameters <- obj.readOpt[io.k8s.api.networking.v1.IngressClassParametersReference]("parameters")
      } yield IngressClassSpec (
          controller = controller,
          parameters = parameters
        )
    }
}

