package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.utils._

/** ServiceAccountSubject holds detailed information for service-account-kind subject. */
final case class ServiceAccountSubject(
  name : String,
  namespace : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ServiceAccountSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ServiceAccountSubject = copy(name = f(name))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ServiceAccountSubject = copy(namespace = value)
  /** transforms namespace to result of function */
  def mapNamespace(f: String => String) : ServiceAccountSubject = copy(namespace = f(namespace))
}

object ServiceAccountSubject {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta2.ServiceAccountSubject, T] = new Encoder[io.k8s.api.flowcontrol.v1beta2.ServiceAccountSubject, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta2.ServiceAccountSubject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("namespace", o.namespace)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ServiceAccountSubject] = new Decoder[T, ServiceAccountSubject] {
      def apply(t: T): Either[String, ServiceAccountSubject] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          namespace <- obj.read[String]("namespace")
      } yield ServiceAccountSubject (
          name = name,
          namespace = namespace
        )
    }
}

