package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s.utils._

/** GroupSubject holds detailed information for group-kind subject. */
final case class GroupSubject(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : GroupSubject = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : GroupSubject = copy(name = f(name))
}

object GroupSubject {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.flowcontrol.v1beta2.GroupSubject, T] = new Encoder[io.k8s.api.flowcontrol.v1beta2.GroupSubject, T] {
        def apply(o: io.k8s.api.flowcontrol.v1beta2.GroupSubject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, GroupSubject] = new Decoder[T, GroupSubject] {
      def apply(t: T): Either[String, GroupSubject] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield GroupSubject (
          name = name
        )
    }
}

