package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents a vSphere volume resource. */
final case class VsphereVirtualDiskVolumeSource(
  volumePath : String,
  fsType : Option[String] = None,
  storagePolicyID : Option[String] = None,
  storagePolicyName : Option[String] = None
) {

  /** Returns a new data with volumePath set to new value */
  def withVolumePath(value: String) : VsphereVirtualDiskVolumeSource = copy(volumePath = value)
  /** transforms volumePath to result of function */
  def mapVolumePath(f: String => String) : VsphereVirtualDiskVolumeSource = copy(volumePath = f(volumePath))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : VsphereVirtualDiskVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : VsphereVirtualDiskVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with storagePolicyID set to new value */
  def withStoragePolicyID(value: String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyID = Some(value))
  /** if storagePolicyID has a value, transforms to the result of function*/
  def mapStoragePolicyID(f: String => String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyID = storagePolicyID.map(f))

  /** Returns a new data with storagePolicyName set to new value */
  def withStoragePolicyName(value: String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyName = Some(value))
  /** if storagePolicyName has a value, transforms to the result of function*/
  def mapStoragePolicyName(f: String => String) : VsphereVirtualDiskVolumeSource = copy(storagePolicyName = storagePolicyName.map(f))
}

object VsphereVirtualDiskVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource, T] = new Encoder[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("volumePath", o.volumePath)
            .write("fsType", o.fsType)
            .write("storagePolicyID", o.storagePolicyID)
            .write("storagePolicyName", o.storagePolicyName)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, VsphereVirtualDiskVolumeSource] = new Decoder[T, VsphereVirtualDiskVolumeSource] {
      def apply(t: T): Either[String, VsphereVirtualDiskVolumeSource] = for {
          obj <- ObjectReader(t)
          volumePath <- obj.read[String]("volumePath")
          fsType <- obj.readOpt[String]("fsType")
          storagePolicyID <- obj.readOpt[String]("storagePolicyID")
          storagePolicyName <- obj.readOpt[String]("storagePolicyName")
      } yield VsphereVirtualDiskVolumeSource (
          volumePath = volumePath,
          fsType = fsType,
          storagePolicyID = storagePolicyID,
          storagePolicyName = storagePolicyName
        )
    }
}

