package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Volume represents a named volume in a pod that may be accessed by any container in the pod. */
final case class Volume(
  name : String,
  secret : Option[io.k8s.api.core.v1.SecretVolumeSource] = None,
  scaleIO : Option[io.k8s.api.core.v1.ScaleIOVolumeSource] = None,
  csi : Option[io.k8s.api.core.v1.CSIVolumeSource] = None,
  azureDisk : Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  azureFile : Option[io.k8s.api.core.v1.AzureFileVolumeSource] = None,
  hostPath : Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  rbd : Option[io.k8s.api.core.v1.RBDVolumeSource] = None,
  configMap : Option[io.k8s.api.core.v1.ConfigMapVolumeSource] = None,
  portworxVolume : Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  glusterfs : Option[io.k8s.api.core.v1.GlusterfsVolumeSource] = None,
  flocker : Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  fc : Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  photonPersistentDisk : Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  gcePersistentDisk : Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  persistentVolumeClaim : Option[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] = None,
  vsphereVolume : Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None,
  projected : Option[io.k8s.api.core.v1.ProjectedVolumeSource] = None,
  ephemeral : Option[io.k8s.api.core.v1.EphemeralVolumeSource] = None,
  iscsi : Option[io.k8s.api.core.v1.ISCSIVolumeSource] = None,
  cinder : Option[io.k8s.api.core.v1.CinderVolumeSource] = None,
  gitRepo : Option[io.k8s.api.core.v1.GitRepoVolumeSource] = None,
  cephfs : Option[io.k8s.api.core.v1.CephFSVolumeSource] = None,
  awsElasticBlockStore : Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  downwardAPI : Option[io.k8s.api.core.v1.DownwardAPIVolumeSource] = None,
  flexVolume : Option[io.k8s.api.core.v1.FlexVolumeSource] = None,
  emptyDir : Option[io.k8s.api.core.v1.EmptyDirVolumeSource] = None,
  nfs : Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  quobyte : Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  storageos : Option[io.k8s.api.core.v1.StorageOSVolumeSource] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : Volume = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : Volume = copy(name = f(name))

  /** Returns a new data with secret set to new value */
  def withSecret(value: io.k8s.api.core.v1.SecretVolumeSource) : Volume = copy(secret = Some(value))
  /** if secret has a value, transforms to the result of function*/
  def mapSecret(f: io.k8s.api.core.v1.SecretVolumeSource => io.k8s.api.core.v1.SecretVolumeSource) : Volume = copy(secret = secret.map(f))

  /** Returns a new data with scaleIO set to new value */
  def withScaleIO(value: io.k8s.api.core.v1.ScaleIOVolumeSource) : Volume = copy(scaleIO = Some(value))
  /** if scaleIO has a value, transforms to the result of function*/
  def mapScaleIO(f: io.k8s.api.core.v1.ScaleIOVolumeSource => io.k8s.api.core.v1.ScaleIOVolumeSource) : Volume = copy(scaleIO = scaleIO.map(f))

  /** Returns a new data with csi set to new value */
  def withCsi(value: io.k8s.api.core.v1.CSIVolumeSource) : Volume = copy(csi = Some(value))
  /** if csi has a value, transforms to the result of function*/
  def mapCsi(f: io.k8s.api.core.v1.CSIVolumeSource => io.k8s.api.core.v1.CSIVolumeSource) : Volume = copy(csi = csi.map(f))

  /** Returns a new data with azureDisk set to new value */
  def withAzureDisk(value: io.k8s.api.core.v1.AzureDiskVolumeSource) : Volume = copy(azureDisk = Some(value))
  /** if azureDisk has a value, transforms to the result of function*/
  def mapAzureDisk(f: io.k8s.api.core.v1.AzureDiskVolumeSource => io.k8s.api.core.v1.AzureDiskVolumeSource) : Volume = copy(azureDisk = azureDisk.map(f))

  /** Returns a new data with azureFile set to new value */
  def withAzureFile(value: io.k8s.api.core.v1.AzureFileVolumeSource) : Volume = copy(azureFile = Some(value))
  /** if azureFile has a value, transforms to the result of function*/
  def mapAzureFile(f: io.k8s.api.core.v1.AzureFileVolumeSource => io.k8s.api.core.v1.AzureFileVolumeSource) : Volume = copy(azureFile = azureFile.map(f))

  /** Returns a new data with hostPath set to new value */
  def withHostPath(value: io.k8s.api.core.v1.HostPathVolumeSource) : Volume = copy(hostPath = Some(value))
  /** if hostPath has a value, transforms to the result of function*/
  def mapHostPath(f: io.k8s.api.core.v1.HostPathVolumeSource => io.k8s.api.core.v1.HostPathVolumeSource) : Volume = copy(hostPath = hostPath.map(f))

  /** Returns a new data with rbd set to new value */
  def withRbd(value: io.k8s.api.core.v1.RBDVolumeSource) : Volume = copy(rbd = Some(value))
  /** if rbd has a value, transforms to the result of function*/
  def mapRbd(f: io.k8s.api.core.v1.RBDVolumeSource => io.k8s.api.core.v1.RBDVolumeSource) : Volume = copy(rbd = rbd.map(f))

  /** Returns a new data with configMap set to new value */
  def withConfigMap(value: io.k8s.api.core.v1.ConfigMapVolumeSource) : Volume = copy(configMap = Some(value))
  /** if configMap has a value, transforms to the result of function*/
  def mapConfigMap(f: io.k8s.api.core.v1.ConfigMapVolumeSource => io.k8s.api.core.v1.ConfigMapVolumeSource) : Volume = copy(configMap = configMap.map(f))

  /** Returns a new data with portworxVolume set to new value */
  def withPortworxVolume(value: io.k8s.api.core.v1.PortworxVolumeSource) : Volume = copy(portworxVolume = Some(value))
  /** if portworxVolume has a value, transforms to the result of function*/
  def mapPortworxVolume(f: io.k8s.api.core.v1.PortworxVolumeSource => io.k8s.api.core.v1.PortworxVolumeSource) : Volume = copy(portworxVolume = portworxVolume.map(f))

  /** Returns a new data with glusterfs set to new value */
  def withGlusterfs(value: io.k8s.api.core.v1.GlusterfsVolumeSource) : Volume = copy(glusterfs = Some(value))
  /** if glusterfs has a value, transforms to the result of function*/
  def mapGlusterfs(f: io.k8s.api.core.v1.GlusterfsVolumeSource => io.k8s.api.core.v1.GlusterfsVolumeSource) : Volume = copy(glusterfs = glusterfs.map(f))

  /** Returns a new data with flocker set to new value */
  def withFlocker(value: io.k8s.api.core.v1.FlockerVolumeSource) : Volume = copy(flocker = Some(value))
  /** if flocker has a value, transforms to the result of function*/
  def mapFlocker(f: io.k8s.api.core.v1.FlockerVolumeSource => io.k8s.api.core.v1.FlockerVolumeSource) : Volume = copy(flocker = flocker.map(f))

  /** Returns a new data with fc set to new value */
  def withFc(value: io.k8s.api.core.v1.FCVolumeSource) : Volume = copy(fc = Some(value))
  /** if fc has a value, transforms to the result of function*/
  def mapFc(f: io.k8s.api.core.v1.FCVolumeSource => io.k8s.api.core.v1.FCVolumeSource) : Volume = copy(fc = fc.map(f))

  /** Returns a new data with photonPersistentDisk set to new value */
  def withPhotonPersistentDisk(value: io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource) : Volume = copy(photonPersistentDisk = Some(value))
  /** if photonPersistentDisk has a value, transforms to the result of function*/
  def mapPhotonPersistentDisk(f: io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource => io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource) : Volume = copy(photonPersistentDisk = photonPersistentDisk.map(f))

  /** Returns a new data with gcePersistentDisk set to new value */
  def withGcePersistentDisk(value: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource) : Volume = copy(gcePersistentDisk = Some(value))
  /** if gcePersistentDisk has a value, transforms to the result of function*/
  def mapGcePersistentDisk(f: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource => io.k8s.api.core.v1.GCEPersistentDiskVolumeSource) : Volume = copy(gcePersistentDisk = gcePersistentDisk.map(f))

  /** Returns a new data with persistentVolumeClaim set to new value */
  def withPersistentVolumeClaim(value: io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource) : Volume = copy(persistentVolumeClaim = Some(value))
  /** if persistentVolumeClaim has a value, transforms to the result of function*/
  def mapPersistentVolumeClaim(f: io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource => io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource) : Volume = copy(persistentVolumeClaim = persistentVolumeClaim.map(f))

  /** Returns a new data with vsphereVolume set to new value */
  def withVsphereVolume(value: io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource) : Volume = copy(vsphereVolume = Some(value))
  /** if vsphereVolume has a value, transforms to the result of function*/
  def mapVsphereVolume(f: io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource => io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource) : Volume = copy(vsphereVolume = vsphereVolume.map(f))

  /** Returns a new data with projected set to new value */
  def withProjected(value: io.k8s.api.core.v1.ProjectedVolumeSource) : Volume = copy(projected = Some(value))
  /** if projected has a value, transforms to the result of function*/
  def mapProjected(f: io.k8s.api.core.v1.ProjectedVolumeSource => io.k8s.api.core.v1.ProjectedVolumeSource) : Volume = copy(projected = projected.map(f))

  /** Returns a new data with ephemeral set to new value */
  def withEphemeral(value: io.k8s.api.core.v1.EphemeralVolumeSource) : Volume = copy(ephemeral = Some(value))
  /** if ephemeral has a value, transforms to the result of function*/
  def mapEphemeral(f: io.k8s.api.core.v1.EphemeralVolumeSource => io.k8s.api.core.v1.EphemeralVolumeSource) : Volume = copy(ephemeral = ephemeral.map(f))

  /** Returns a new data with iscsi set to new value */
  def withIscsi(value: io.k8s.api.core.v1.ISCSIVolumeSource) : Volume = copy(iscsi = Some(value))
  /** if iscsi has a value, transforms to the result of function*/
  def mapIscsi(f: io.k8s.api.core.v1.ISCSIVolumeSource => io.k8s.api.core.v1.ISCSIVolumeSource) : Volume = copy(iscsi = iscsi.map(f))

  /** Returns a new data with cinder set to new value */
  def withCinder(value: io.k8s.api.core.v1.CinderVolumeSource) : Volume = copy(cinder = Some(value))
  /** if cinder has a value, transforms to the result of function*/
  def mapCinder(f: io.k8s.api.core.v1.CinderVolumeSource => io.k8s.api.core.v1.CinderVolumeSource) : Volume = copy(cinder = cinder.map(f))

  /** Returns a new data with gitRepo set to new value */
  def withGitRepo(value: io.k8s.api.core.v1.GitRepoVolumeSource) : Volume = copy(gitRepo = Some(value))
  /** if gitRepo has a value, transforms to the result of function*/
  def mapGitRepo(f: io.k8s.api.core.v1.GitRepoVolumeSource => io.k8s.api.core.v1.GitRepoVolumeSource) : Volume = copy(gitRepo = gitRepo.map(f))

  /** Returns a new data with cephfs set to new value */
  def withCephfs(value: io.k8s.api.core.v1.CephFSVolumeSource) : Volume = copy(cephfs = Some(value))
  /** if cephfs has a value, transforms to the result of function*/
  def mapCephfs(f: io.k8s.api.core.v1.CephFSVolumeSource => io.k8s.api.core.v1.CephFSVolumeSource) : Volume = copy(cephfs = cephfs.map(f))

  /** Returns a new data with awsElasticBlockStore set to new value */
  def withAwsElasticBlockStore(value: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource) : Volume = copy(awsElasticBlockStore = Some(value))
  /** if awsElasticBlockStore has a value, transforms to the result of function*/
  def mapAwsElasticBlockStore(f: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource => io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource) : Volume = copy(awsElasticBlockStore = awsElasticBlockStore.map(f))

  /** Returns a new data with downwardAPI set to new value */
  def withDownwardAPI(value: io.k8s.api.core.v1.DownwardAPIVolumeSource) : Volume = copy(downwardAPI = Some(value))
  /** if downwardAPI has a value, transforms to the result of function*/
  def mapDownwardAPI(f: io.k8s.api.core.v1.DownwardAPIVolumeSource => io.k8s.api.core.v1.DownwardAPIVolumeSource) : Volume = copy(downwardAPI = downwardAPI.map(f))

  /** Returns a new data with flexVolume set to new value */
  def withFlexVolume(value: io.k8s.api.core.v1.FlexVolumeSource) : Volume = copy(flexVolume = Some(value))
  /** if flexVolume has a value, transforms to the result of function*/
  def mapFlexVolume(f: io.k8s.api.core.v1.FlexVolumeSource => io.k8s.api.core.v1.FlexVolumeSource) : Volume = copy(flexVolume = flexVolume.map(f))

  /** Returns a new data with emptyDir set to new value */
  def withEmptyDir(value: io.k8s.api.core.v1.EmptyDirVolumeSource) : Volume = copy(emptyDir = Some(value))
  /** if emptyDir has a value, transforms to the result of function*/
  def mapEmptyDir(f: io.k8s.api.core.v1.EmptyDirVolumeSource => io.k8s.api.core.v1.EmptyDirVolumeSource) : Volume = copy(emptyDir = emptyDir.map(f))

  /** Returns a new data with nfs set to new value */
  def withNfs(value: io.k8s.api.core.v1.NFSVolumeSource) : Volume = copy(nfs = Some(value))
  /** if nfs has a value, transforms to the result of function*/
  def mapNfs(f: io.k8s.api.core.v1.NFSVolumeSource => io.k8s.api.core.v1.NFSVolumeSource) : Volume = copy(nfs = nfs.map(f))

  /** Returns a new data with quobyte set to new value */
  def withQuobyte(value: io.k8s.api.core.v1.QuobyteVolumeSource) : Volume = copy(quobyte = Some(value))
  /** if quobyte has a value, transforms to the result of function*/
  def mapQuobyte(f: io.k8s.api.core.v1.QuobyteVolumeSource => io.k8s.api.core.v1.QuobyteVolumeSource) : Volume = copy(quobyte = quobyte.map(f))

  /** Returns a new data with storageos set to new value */
  def withStorageos(value: io.k8s.api.core.v1.StorageOSVolumeSource) : Volume = copy(storageos = Some(value))
  /** if storageos has a value, transforms to the result of function*/
  def mapStorageos(f: io.k8s.api.core.v1.StorageOSVolumeSource => io.k8s.api.core.v1.StorageOSVolumeSource) : Volume = copy(storageos = storageos.map(f))
}

object Volume {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.Volume, T] = new Encoder[io.k8s.api.core.v1.Volume, T] {
        def apply(o: io.k8s.api.core.v1.Volume) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("secret", o.secret)
            .write("scaleIO", o.scaleIO)
            .write("csi", o.csi)
            .write("azureDisk", o.azureDisk)
            .write("azureFile", o.azureFile)
            .write("hostPath", o.hostPath)
            .write("rbd", o.rbd)
            .write("configMap", o.configMap)
            .write("portworxVolume", o.portworxVolume)
            .write("glusterfs", o.glusterfs)
            .write("flocker", o.flocker)
            .write("fc", o.fc)
            .write("photonPersistentDisk", o.photonPersistentDisk)
            .write("gcePersistentDisk", o.gcePersistentDisk)
            .write("persistentVolumeClaim", o.persistentVolumeClaim)
            .write("vsphereVolume", o.vsphereVolume)
            .write("projected", o.projected)
            .write("ephemeral", o.ephemeral)
            .write("iscsi", o.iscsi)
            .write("cinder", o.cinder)
            .write("gitRepo", o.gitRepo)
            .write("cephfs", o.cephfs)
            .write("awsElasticBlockStore", o.awsElasticBlockStore)
            .write("downwardAPI", o.downwardAPI)
            .write("flexVolume", o.flexVolume)
            .write("emptyDir", o.emptyDir)
            .write("nfs", o.nfs)
            .write("quobyte", o.quobyte)
            .write("storageos", o.storageos)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, Volume] = new Decoder[T, Volume] {
      def apply(t: T): Either[String, Volume] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          secret <- obj.readOpt[io.k8s.api.core.v1.SecretVolumeSource]("secret")
          scaleIO <- obj.readOpt[io.k8s.api.core.v1.ScaleIOVolumeSource]("scaleIO")
          csi <- obj.readOpt[io.k8s.api.core.v1.CSIVolumeSource]("csi")
          azureDisk <- obj.readOpt[io.k8s.api.core.v1.AzureDiskVolumeSource]("azureDisk")
          azureFile <- obj.readOpt[io.k8s.api.core.v1.AzureFileVolumeSource]("azureFile")
          hostPath <- obj.readOpt[io.k8s.api.core.v1.HostPathVolumeSource]("hostPath")
          rbd <- obj.readOpt[io.k8s.api.core.v1.RBDVolumeSource]("rbd")
          configMap <- obj.readOpt[io.k8s.api.core.v1.ConfigMapVolumeSource]("configMap")
          portworxVolume <- obj.readOpt[io.k8s.api.core.v1.PortworxVolumeSource]("portworxVolume")
          glusterfs <- obj.readOpt[io.k8s.api.core.v1.GlusterfsVolumeSource]("glusterfs")
          flocker <- obj.readOpt[io.k8s.api.core.v1.FlockerVolumeSource]("flocker")
          fc <- obj.readOpt[io.k8s.api.core.v1.FCVolumeSource]("fc")
          photonPersistentDisk <- obj.readOpt[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource]("photonPersistentDisk")
          gcePersistentDisk <- obj.readOpt[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource]("gcePersistentDisk")
          persistentVolumeClaim <- obj.readOpt[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource]("persistentVolumeClaim")
          vsphereVolume <- obj.readOpt[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource]("vsphereVolume")
          projected <- obj.readOpt[io.k8s.api.core.v1.ProjectedVolumeSource]("projected")
          ephemeral <- obj.readOpt[io.k8s.api.core.v1.EphemeralVolumeSource]("ephemeral")
          iscsi <- obj.readOpt[io.k8s.api.core.v1.ISCSIVolumeSource]("iscsi")
          cinder <- obj.readOpt[io.k8s.api.core.v1.CinderVolumeSource]("cinder")
          gitRepo <- obj.readOpt[io.k8s.api.core.v1.GitRepoVolumeSource]("gitRepo")
          cephfs <- obj.readOpt[io.k8s.api.core.v1.CephFSVolumeSource]("cephfs")
          awsElasticBlockStore <- obj.readOpt[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource]("awsElasticBlockStore")
          downwardAPI <- obj.readOpt[io.k8s.api.core.v1.DownwardAPIVolumeSource]("downwardAPI")
          flexVolume <- obj.readOpt[io.k8s.api.core.v1.FlexVolumeSource]("flexVolume")
          emptyDir <- obj.readOpt[io.k8s.api.core.v1.EmptyDirVolumeSource]("emptyDir")
          nfs <- obj.readOpt[io.k8s.api.core.v1.NFSVolumeSource]("nfs")
          quobyte <- obj.readOpt[io.k8s.api.core.v1.QuobyteVolumeSource]("quobyte")
          storageos <- obj.readOpt[io.k8s.api.core.v1.StorageOSVolumeSource]("storageos")
      } yield Volume (
          name = name,
          secret = secret,
          scaleIO = scaleIO,
          csi = csi,
          azureDisk = azureDisk,
          azureFile = azureFile,
          hostPath = hostPath,
          rbd = rbd,
          configMap = configMap,
          portworxVolume = portworxVolume,
          glusterfs = glusterfs,
          flocker = flocker,
          fc = fc,
          photonPersistentDisk = photonPersistentDisk,
          gcePersistentDisk = gcePersistentDisk,
          persistentVolumeClaim = persistentVolumeClaim,
          vsphereVolume = vsphereVolume,
          projected = projected,
          ephemeral = ephemeral,
          iscsi = iscsi,
          cinder = cinder,
          gitRepo = gitRepo,
          cephfs = cephfs,
          awsElasticBlockStore = awsElasticBlockStore,
          downwardAPI = downwardAPI,
          flexVolume = flexVolume,
          emptyDir = emptyDir,
          nfs = nfs,
          quobyte = quobyte,
          storageos = storageos
        )
    }
}

