package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** SecretReference represents a Secret Reference. It has enough information to retrieve secret in any namespace */
final case class SecretReference(
  name : Option[String] = None,
  namespace : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : SecretReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : SecretReference = copy(name = name.map(f))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : SecretReference = copy(namespace = Some(value))
  /** if namespace has a value, transforms to the result of function*/
  def mapNamespace(f: String => String) : SecretReference = copy(namespace = namespace.map(f))
}

object SecretReference {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.SecretReference, T] = new Encoder[io.k8s.api.core.v1.SecretReference, T] {
        def apply(o: io.k8s.api.core.v1.SecretReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("namespace", o.namespace)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, SecretReference] = new Decoder[T, SecretReference] {
      def apply(t: T): Either[String, SecretReference] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
          namespace <- obj.readOpt[String]("namespace")
      } yield SecretReference (
          name = name,
          namespace = namespace
        )
    }
}

