package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** SeccompProfile defines a pod/container's seccomp profile settings. Only one profile source may be set. */
final case class SeccompProfile(
  `type` : String,
  localhostProfile : Option[String] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : SeccompProfile = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : SeccompProfile = copy(`type` = f(`type`))

  /** Returns a new data with localhostProfile set to new value */
  def withLocalhostProfile(value: String) : SeccompProfile = copy(localhostProfile = Some(value))
  /** if localhostProfile has a value, transforms to the result of function*/
  def mapLocalhostProfile(f: String => String) : SeccompProfile = copy(localhostProfile = localhostProfile.map(f))
}

object SeccompProfile {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.SeccompProfile, T] = new Encoder[io.k8s.api.core.v1.SeccompProfile, T] {
        def apply(o: io.k8s.api.core.v1.SeccompProfile) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("localhostProfile", o.localhostProfile)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, SeccompProfile] = new Decoder[T, SeccompProfile] {
      def apply(t: T): Either[String, SeccompProfile] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          localhostProfile <- obj.readOpt[String]("localhostProfile")
      } yield SeccompProfile (
          `type` = `type`,
          localhostProfile = localhostProfile
        )
    }
}

