package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PortworxVolumeSource represents a Portworx volume resource. */
final case class PortworxVolumeSource(
  volumeID : String,
  fsType : Option[String] = None,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with volumeID set to new value */
  def withVolumeID(value: String) : PortworxVolumeSource = copy(volumeID = value)
  /** transforms volumeID to result of function */
  def mapVolumeID(f: String => String) : PortworxVolumeSource = copy(volumeID = f(volumeID))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : PortworxVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : PortworxVolumeSource = copy(fsType = fsType.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : PortworxVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : PortworxVolumeSource = copy(readOnly = readOnly.map(f))
}

object PortworxVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PortworxVolumeSource, T] = new Encoder[io.k8s.api.core.v1.PortworxVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.PortworxVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("volumeID", o.volumeID)
            .write("fsType", o.fsType)
            .write("readOnly", o.readOnly)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PortworxVolumeSource] = new Decoder[T, PortworxVolumeSource] {
      def apply(t: T): Either[String, PortworxVolumeSource] = for {
          obj <- ObjectReader(t)
          volumeID <- obj.read[String]("volumeID")
          fsType <- obj.readOpt[String]("fsType")
          readOnly <- obj.readOpt[Boolean]("readOnly")
      } yield PortworxVolumeSource (
          volumeID = volumeID,
          fsType = fsType,
          readOnly = readOnly
        )
    }
}

