package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Pod affinity is a group of inter pod affinity scheduling rules. */
final case class PodAffinity(
  preferredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]] = None,
  requiredDuringSchedulingIgnoredDuringExecution : Option[Seq[io.k8s.api.core.v1.PodAffinityTerm]] = None
) {

  /** Returns a new data with preferredDuringSchedulingIgnoredDuringExecution set to new value */
  def withPreferredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]) : PodAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(value))
  /** Appends new values to preferredDuringSchedulingIgnoredDuringExecution */
  def addPreferredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.WeightedPodAffinityTerm*) : PodAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = Some(preferredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))
  /** if preferredDuringSchedulingIgnoredDuringExecution has a value, transforms to the result of function*/
  def mapPreferredDuringSchedulingIgnoredDuringExecution(f: Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm] => Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]) : PodAffinity = copy(preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution.map(f))

  /** Returns a new data with requiredDuringSchedulingIgnoredDuringExecution set to new value */
  def withRequiredDuringSchedulingIgnoredDuringExecution(value: Seq[io.k8s.api.core.v1.PodAffinityTerm]) : PodAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(value))
  /** Appends new values to requiredDuringSchedulingIgnoredDuringExecution */
  def addRequiredDuringSchedulingIgnoredDuringExecution(newValues: io.k8s.api.core.v1.PodAffinityTerm*) : PodAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = Some(requiredDuringSchedulingIgnoredDuringExecution.fold(newValues)(_ ++ newValues)))
  /** if requiredDuringSchedulingIgnoredDuringExecution has a value, transforms to the result of function*/
  def mapRequiredDuringSchedulingIgnoredDuringExecution(f: Seq[io.k8s.api.core.v1.PodAffinityTerm] => Seq[io.k8s.api.core.v1.PodAffinityTerm]) : PodAffinity = copy(requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution.map(f))
}

object PodAffinity {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.PodAffinity, T] = new Encoder[io.k8s.api.core.v1.PodAffinity, T] {
        def apply(o: io.k8s.api.core.v1.PodAffinity) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("preferredDuringSchedulingIgnoredDuringExecution", o.preferredDuringSchedulingIgnoredDuringExecution)
            .write("requiredDuringSchedulingIgnoredDuringExecution", o.requiredDuringSchedulingIgnoredDuringExecution)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, PodAffinity] = new Decoder[T, PodAffinity] {
      def apply(t: T): Either[String, PodAffinity] = for {
          obj <- ObjectReader(t)
          preferredDuringSchedulingIgnoredDuringExecution <- obj.readOpt[Seq[io.k8s.api.core.v1.WeightedPodAffinityTerm]]("preferredDuringSchedulingIgnoredDuringExecution")
          requiredDuringSchedulingIgnoredDuringExecution <- obj.readOpt[Seq[io.k8s.api.core.v1.PodAffinityTerm]]("requiredDuringSchedulingIgnoredDuringExecution")
      } yield PodAffinity (
          preferredDuringSchedulingIgnoredDuringExecution = preferredDuringSchedulingIgnoredDuringExecution,
          requiredDuringSchedulingIgnoredDuringExecution = requiredDuringSchedulingIgnoredDuringExecution
        )
    }
}

