package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NamespaceSpec describes the attributes on a Namespace. */
final case class NamespaceSpec(
  finalizers : Option[Seq[String]] = None
) {

  /** Returns a new data with finalizers set to new value */
  def withFinalizers(value: Seq[String]) : NamespaceSpec = copy(finalizers = Some(value))
  /** Appends new values to finalizers */
  def addFinalizers(newValues: String*) : NamespaceSpec = copy(finalizers = Some(finalizers.fold(newValues)(_ ++ newValues)))
  /** if finalizers has a value, transforms to the result of function*/
  def mapFinalizers(f: Seq[String] => Seq[String]) : NamespaceSpec = copy(finalizers = finalizers.map(f))
}

object NamespaceSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.NamespaceSpec, T] = new Encoder[io.k8s.api.core.v1.NamespaceSpec, T] {
        def apply(o: io.k8s.api.core.v1.NamespaceSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("finalizers", o.finalizers)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NamespaceSpec] = new Decoder[T, NamespaceSpec] {
      def apply(t: T): Either[String, NamespaceSpec] = for {
          obj <- ObjectReader(t)
          finalizers <- obj.readOpt[Seq[String]]("finalizers")
      } yield NamespaceSpec (
          finalizers = finalizers
        )
    }
}

