package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** NamespaceList is a list of Namespaces. */
final case class NamespaceList(
  items : Seq[io.k8s.api.core.v1.Namespace],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "NamespaceList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.Namespace]) : NamespaceList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.Namespace*) : NamespaceList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.Namespace] => Seq[io.k8s.api.core.v1.Namespace]) : NamespaceList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : NamespaceList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : NamespaceList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = NamespaceList.encoder[T].apply(this)
}

object NamespaceList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.NamespaceList, T] = new Encoder[io.k8s.api.core.v1.NamespaceList, T] {
        def apply(o: io.k8s.api.core.v1.NamespaceList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, NamespaceList] = new Decoder[T, NamespaceList] {
      def apply(t: T): Either[String, NamespaceList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.Namespace]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield NamespaceList (
          items = items,
          metadata = metadata
        )
    }
}

