package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** LimitRangeSpec defines a min/max usage limit for resources that match on kind. */
final case class LimitRangeSpec(
  limits : Seq[io.k8s.api.core.v1.LimitRangeItem]
) {

  /** Returns a new data with limits set to new value */
  def withLimits(value: Seq[io.k8s.api.core.v1.LimitRangeItem]) : LimitRangeSpec = copy(limits = value)
  /** Appends new values to limits */
  def addLimits(newValues: io.k8s.api.core.v1.LimitRangeItem*) : LimitRangeSpec = copy(limits = limits ++ newValues)
  /** transforms limits to result of function */
  def mapLimits(f: Seq[io.k8s.api.core.v1.LimitRangeItem] => Seq[io.k8s.api.core.v1.LimitRangeItem]) : LimitRangeSpec = copy(limits = f(limits))
}

object LimitRangeSpec {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.LimitRangeSpec, T] = new Encoder[io.k8s.api.core.v1.LimitRangeSpec, T] {
        def apply(o: io.k8s.api.core.v1.LimitRangeSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("limits", o.limits)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, LimitRangeSpec] = new Decoder[T, LimitRangeSpec] {
      def apply(t: T): Either[String, LimitRangeSpec] = for {
          obj <- ObjectReader(t)
          limits <- obj.read[Seq[io.k8s.api.core.v1.LimitRangeItem]]("limits")
      } yield LimitRangeSpec (
          limits = limits
        )
    }
}

