package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** LimitRangeItem defines a min/max usage limit for any resource that matches on kind. */
final case class LimitRangeItem(
  `type` : String,
  defaultRequest : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  min : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  maxLimitRequestRatio : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  max : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  default : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : LimitRangeItem = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : LimitRangeItem = copy(`type` = f(`type`))

  /** Returns a new data with defaultRequest set to new value */
  def withDefaultRequest(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(defaultRequest = Some(value))
  /** Adds new values to defaultRequest */
  def addDefaultRequest(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(defaultRequest = Some(defaultRequest.fold(newValues.toMap)(_ ++ newValues)))
  /** if defaultRequest has a value, transforms to the result of function*/
  def mapDefaultRequest(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(defaultRequest = defaultRequest.map(f))

  /** Returns a new data with min set to new value */
  def withMin(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(min = Some(value))
  /** Adds new values to min */
  def addMin(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(min = Some(min.fold(newValues.toMap)(_ ++ newValues)))
  /** if min has a value, transforms to the result of function*/
  def mapMin(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(min = min.map(f))

  /** Returns a new data with maxLimitRequestRatio set to new value */
  def withMaxLimitRequestRatio(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(maxLimitRequestRatio = Some(value))
  /** Adds new values to maxLimitRequestRatio */
  def addMaxLimitRequestRatio(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(maxLimitRequestRatio = Some(maxLimitRequestRatio.fold(newValues.toMap)(_ ++ newValues)))
  /** if maxLimitRequestRatio has a value, transforms to the result of function*/
  def mapMaxLimitRequestRatio(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(maxLimitRequestRatio = maxLimitRequestRatio.map(f))

  /** Returns a new data with max set to new value */
  def withMax(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(max = Some(value))
  /** Adds new values to max */
  def addMax(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(max = Some(max.fold(newValues.toMap)(_ ++ newValues)))
  /** if max has a value, transforms to the result of function*/
  def mapMax(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(max = max.map(f))

  /** Returns a new data with default set to new value */
  def withDefault(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(default = Some(value))
  /** Adds new values to default */
  def addDefault(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : LimitRangeItem = copy(default = Some(default.fold(newValues.toMap)(_ ++ newValues)))
  /** if default has a value, transforms to the result of function*/
  def mapDefault(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : LimitRangeItem = copy(default = default.map(f))
}

object LimitRangeItem {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.LimitRangeItem, T] = new Encoder[io.k8s.api.core.v1.LimitRangeItem, T] {
        def apply(o: io.k8s.api.core.v1.LimitRangeItem) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("defaultRequest", o.defaultRequest)
            .write("min", o.min)
            .write("maxLimitRequestRatio", o.maxLimitRequestRatio)
            .write("max", o.max)
            .write("default", o.default)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, LimitRangeItem] = new Decoder[T, LimitRangeItem] {
      def apply(t: T): Either[String, LimitRangeItem] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          defaultRequest <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("defaultRequest")
          min <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("min")
          maxLimitRequestRatio <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("maxLimitRequestRatio")
          max <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("max")
          default <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("default")
      } yield LimitRangeItem (
          `type` = `type`,
          defaultRequest = defaultRequest,
          min = min,
          maxLimitRequestRatio = maxLimitRequestRatio,
          max = max,
          default = default
        )
    }
}

