package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** EventSource contains information for an event. */
final case class EventSource(
  component : Option[String] = None,
  host : Option[String] = None
) {

  /** Returns a new data with component set to new value */
  def withComponent(value: String) : EventSource = copy(component = Some(value))
  /** if component has a value, transforms to the result of function*/
  def mapComponent(f: String => String) : EventSource = copy(component = component.map(f))

  /** Returns a new data with host set to new value */
  def withHost(value: String) : EventSource = copy(host = Some(value))
  /** if host has a value, transforms to the result of function*/
  def mapHost(f: String => String) : EventSource = copy(host = host.map(f))
}

object EventSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.EventSource, T] = new Encoder[io.k8s.api.core.v1.EventSource, T] {
        def apply(o: io.k8s.api.core.v1.EventSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("component", o.component)
            .write("host", o.host)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, EventSource] = new Decoder[T, EventSource] {
      def apply(t: T): Either[String, EventSource] = for {
          obj <- ObjectReader(t)
          component <- obj.readOpt[String]("component")
          host <- obj.readOpt[String]("host")
      } yield EventSource (
          component = component,
          host = host
        )
    }
}

