package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** DownwardAPIVolumeSource represents a volume containing downward API info. Downward API volumes support ownership management and SELinux relabeling. */
final case class DownwardAPIVolumeSource(
  defaultMode : Option[Int] = None,
  items : Option[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]] = None
) {

  /** Returns a new data with defaultMode set to new value */
  def withDefaultMode(value: Int) : DownwardAPIVolumeSource = copy(defaultMode = Some(value))
  /** if defaultMode has a value, transforms to the result of function*/
  def mapDefaultMode(f: Int => Int) : DownwardAPIVolumeSource = copy(defaultMode = defaultMode.map(f))

  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIVolumeSource = copy(items = Some(value))
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.DownwardAPIVolumeFile*) : DownwardAPIVolumeSource = copy(items = Some(items.fold(newValues)(_ ++ newValues)))
  /** if items has a value, transforms to the result of function*/
  def mapItems(f: Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile] => Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]) : DownwardAPIVolumeSource = copy(items = items.map(f))
}

object DownwardAPIVolumeSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.DownwardAPIVolumeSource, T] = new Encoder[io.k8s.api.core.v1.DownwardAPIVolumeSource, T] {
        def apply(o: io.k8s.api.core.v1.DownwardAPIVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("defaultMode", o.defaultMode)
            .write("items", o.items)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, DownwardAPIVolumeSource] = new Decoder[T, DownwardAPIVolumeSource] {
      def apply(t: T): Either[String, DownwardAPIVolumeSource] = for {
          obj <- ObjectReader(t)
          defaultMode <- obj.readOpt[Int]("defaultMode")
          items <- obj.readOpt[Seq[io.k8s.api.core.v1.DownwardAPIVolumeFile]]("items")
      } yield DownwardAPIVolumeSource (
          defaultMode = defaultMode,
          items = items
        )
    }
}

