package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Status of all the conditions for the component as a list of ComponentStatus objects. Deprecated: This API is deprecated in v1.19+ */
final case class ComponentStatusList(
  items : Seq[io.k8s.api.core.v1.ComponentStatus],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ComponentStatusList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.core.v1.ComponentStatus]) : ComponentStatusList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.core.v1.ComponentStatus*) : ComponentStatusList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.core.v1.ComponentStatus] => Seq[io.k8s.api.core.v1.ComponentStatus]) : ComponentStatusList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ComponentStatusList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ComponentStatusList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ComponentStatusList.encoder[T].apply(this)
}

object ComponentStatusList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ComponentStatusList, T] = new Encoder[io.k8s.api.core.v1.ComponentStatusList, T] {
        def apply(o: io.k8s.api.core.v1.ComponentStatusList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ComponentStatusList] = new Decoder[T, ComponentStatusList] {
      def apply(t: T): Either[String, ComponentStatusList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.core.v1.ComponentStatus]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield ComponentStatusList (
          items = items,
          metadata = metadata
        )
    }
}

