package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Information about the condition of a component. */
final case class ComponentCondition(
  status : String,
  `type` : String,
  error : Option[String] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : ComponentCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : ComponentCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : ComponentCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : ComponentCondition = copy(`type` = f(`type`))

  /** Returns a new data with error set to new value */
  def withError(value: String) : ComponentCondition = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : ComponentCondition = copy(error = error.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ComponentCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ComponentCondition = copy(message = message.map(f))
}

object ComponentCondition {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.core.v1.ComponentCondition, T] = new Encoder[io.k8s.api.core.v1.ComponentCondition, T] {
        def apply(o: io.k8s.api.core.v1.ComponentCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("error", o.error)
            .write("message", o.message)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ComponentCondition] = new Decoder[T, ComponentCondition] {
      def apply(t: T): Either[String, ComponentCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          error <- obj.readOpt[String]("error")
          message <- obj.readOpt[String]("message")
      } yield ComponentCondition (
          status = status,
          `type` = `type`,
          error = error,
          message = message
        )
    }
}

