package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** MetricTarget defines the target value, average value, or average utilization of a specific metric */
final case class MetricTarget(
  `type` : String,
  averageUtilization : Option[Int] = None,
  averageValue : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None,
  value : Option[io.k8s.apimachinery.pkg.api.resource.Quantity] = None
) {

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : MetricTarget = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : MetricTarget = copy(`type` = f(`type`))

  /** Returns a new data with averageUtilization set to new value */
  def withAverageUtilization(value: Int) : MetricTarget = copy(averageUtilization = Some(value))
  /** if averageUtilization has a value, transforms to the result of function*/
  def mapAverageUtilization(f: Int => Int) : MetricTarget = copy(averageUtilization = averageUtilization.map(f))

  /** Returns a new data with averageValue set to new value */
  def withAverageValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricTarget = copy(averageValue = Some(value))
  /** if averageValue has a value, transforms to the result of function*/
  def mapAverageValue(f: io.k8s.apimachinery.pkg.api.resource.Quantity => io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricTarget = copy(averageValue = averageValue.map(f))

  /** Returns a new data with value set to new value */
  def withValue(value: io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricTarget = copy(value = Some(value))
  /** if value has a value, transforms to the result of function*/
  def mapValue(f: io.k8s.apimachinery.pkg.api.resource.Quantity => io.k8s.apimachinery.pkg.api.resource.Quantity) : MetricTarget = copy(value = value.map(f))
}

object MetricTarget {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2.MetricTarget, T] = new Encoder[io.k8s.api.autoscaling.v2.MetricTarget, T] {
        def apply(o: io.k8s.api.autoscaling.v2.MetricTarget) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("type", o.`type`)
            .write("averageUtilization", o.averageUtilization)
            .write("averageValue", o.averageValue)
            .write("value", o.value)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, MetricTarget] = new Decoder[T, MetricTarget] {
      def apply(t: T): Either[String, MetricTarget] = for {
          obj <- ObjectReader(t)
          `type` <- obj.read[String]("type")
          averageUtilization <- obj.readOpt[Int]("averageUtilization")
          averageValue <- obj.readOpt[io.k8s.apimachinery.pkg.api.resource.Quantity]("averageValue")
          value <- obj.readOpt[io.k8s.apimachinery.pkg.api.resource.Quantity]("value")
      } yield MetricTarget (
          `type` = `type`,
          averageUtilization = averageUtilization,
          averageValue = averageValue,
          value = value
        )
    }
}

