package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). */
final case class ExternalMetricSource(
  metric : io.k8s.api.autoscaling.v2.MetricIdentifier,
  target : io.k8s.api.autoscaling.v2.MetricTarget
) {

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2.MetricIdentifier) : ExternalMetricSource = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2.MetricIdentifier => io.k8s.api.autoscaling.v2.MetricIdentifier) : ExternalMetricSource = copy(metric = f(metric))

  /** Returns a new data with target set to new value */
  def withTarget(value: io.k8s.api.autoscaling.v2.MetricTarget) : ExternalMetricSource = copy(target = value)
  /** transforms target to result of function */
  def mapTarget(f: io.k8s.api.autoscaling.v2.MetricTarget => io.k8s.api.autoscaling.v2.MetricTarget) : ExternalMetricSource = copy(target = f(target))
}

object ExternalMetricSource {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v2.ExternalMetricSource, T] = new Encoder[io.k8s.api.autoscaling.v2.ExternalMetricSource, T] {
        def apply(o: io.k8s.api.autoscaling.v2.ExternalMetricSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metric", o.metric)
            .write("target", o.target)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, ExternalMetricSource] = new Decoder[T, ExternalMetricSource] {
      def apply(t: T): Either[String, ExternalMetricSource] = for {
          obj <- ObjectReader(t)
          metric <- obj.read[io.k8s.api.autoscaling.v2.MetricIdentifier]("metric")
          target <- obj.read[io.k8s.api.autoscaling.v2.MetricTarget]("target")
      } yield ExternalMetricSource (
          metric = metric,
          target = target
        )
    }
}

