package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** list of horizontal pod autoscaler objects. */
final case class HorizontalPodAutoscalerList(
  items : Seq[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "HorizontalPodAutoscalerList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler]) : HorizontalPodAutoscalerList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler*) : HorizontalPodAutoscalerList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler] => Seq[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler]) : HorizontalPodAutoscalerList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : HorizontalPodAutoscalerList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : HorizontalPodAutoscalerList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = HorizontalPodAutoscalerList.encoder[T].apply(this)
}

object HorizontalPodAutoscalerList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList, T] = new Encoder[io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList, T] {
        def apply(o: io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, HorizontalPodAutoscalerList] = new Decoder[T, HorizontalPodAutoscalerList] {
      def apply(t: T): Either[String, HorizontalPodAutoscalerList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield HorizontalPodAutoscalerList (
          items = items,
          metadata = metadata
        )
    }
}

