package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means "in all namespaces".  Self is a special case, because users should always be able to check whether they can perform an action */
final case class SelfSubjectAccessReview(
  spec : io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec,
  status : Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "SelfSubjectAccessReview", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec) : SelfSubjectAccessReview = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec => io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec) : SelfSubjectAccessReview = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SelfSubjectAccessReview = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authorization.v1.SubjectAccessReviewStatus => io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : SelfSubjectAccessReview = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectAccessReview = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : SelfSubjectAccessReview = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = SelfSubjectAccessReview.encoder[T].apply(this)
}

object SelfSubjectAccessReview {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.authorization.v1.SelfSubjectAccessReview, T] = new Encoder[io.k8s.api.authorization.v1.SelfSubjectAccessReview, T] {
        def apply(o: io.k8s.api.authorization.v1.SelfSubjectAccessReview) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, SelfSubjectAccessReview] = new Decoder[T, SelfSubjectAccessReview] {
      def apply(t: T): Either[String, SelfSubjectAccessReview] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec]("spec")
          status <- obj.readOpt[io.k8s.api.authorization.v1.SubjectAccessReviewStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield SelfSubjectAccessReview (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

