package io.k8s.api.authorization.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking. */
final case class LocalSubjectAccessReview(
  spec : io.k8s.api.authorization.v1.SubjectAccessReviewSpec,
  status : Option[io.k8s.api.authorization.v1.SubjectAccessReviewStatus] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("authorization.k8s.io", "LocalSubjectAccessReview", "v1")


  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.authorization.v1.SubjectAccessReviewSpec) : LocalSubjectAccessReview = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.authorization.v1.SubjectAccessReviewSpec => io.k8s.api.authorization.v1.SubjectAccessReviewSpec) : LocalSubjectAccessReview = copy(spec = f(spec))

  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : LocalSubjectAccessReview = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.authorization.v1.SubjectAccessReviewStatus => io.k8s.api.authorization.v1.SubjectAccessReviewStatus) : LocalSubjectAccessReview = copy(status = status.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LocalSubjectAccessReview = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : LocalSubjectAccessReview = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = LocalSubjectAccessReview.encoder[T].apply(this)
}

object LocalSubjectAccessReview {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.authorization.v1.LocalSubjectAccessReview, T] = new Encoder[io.k8s.api.authorization.v1.LocalSubjectAccessReview, T] {
        def apply(o: io.k8s.api.authorization.v1.LocalSubjectAccessReview) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("status", o.status)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, LocalSubjectAccessReview] = new Decoder[T, LocalSubjectAccessReview] {
      def apply(t: T): Either[String, LocalSubjectAccessReview] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.authorization.v1.SubjectAccessReviewSpec]("spec")
          status <- obj.readOpt[io.k8s.api.authorization.v1.SubjectAccessReviewStatus]("status")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield LocalSubjectAccessReview (
          spec = spec,
          status = status,
          metadata = metadata
        )
    }
}

