package io.k8s.api.authentication.v1

import dev.hnaderi.k8s.utils._

/** TokenReviewStatus is the result of the token authentication request. */
final case class TokenReviewStatus(
  audiences : Option[Seq[String]] = None,
  authenticated : Option[Boolean] = None,
  error : Option[String] = None,
  user : Option[io.k8s.api.authentication.v1.UserInfo] = None
) {

  /** Returns a new data with audiences set to new value */
  def withAudiences(value: Seq[String]) : TokenReviewStatus = copy(audiences = Some(value))
  /** Appends new values to audiences */
  def addAudiences(newValues: String*) : TokenReviewStatus = copy(audiences = Some(audiences.fold(newValues)(_ ++ newValues)))
  /** if audiences has a value, transforms to the result of function*/
  def mapAudiences(f: Seq[String] => Seq[String]) : TokenReviewStatus = copy(audiences = audiences.map(f))

  /** Returns a new data with authenticated set to new value */
  def withAuthenticated(value: Boolean) : TokenReviewStatus = copy(authenticated = Some(value))
  /** if authenticated has a value, transforms to the result of function*/
  def mapAuthenticated(f: Boolean => Boolean) : TokenReviewStatus = copy(authenticated = authenticated.map(f))

  /** Returns a new data with error set to new value */
  def withError(value: String) : TokenReviewStatus = copy(error = Some(value))
  /** if error has a value, transforms to the result of function*/
  def mapError(f: String => String) : TokenReviewStatus = copy(error = error.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: io.k8s.api.authentication.v1.UserInfo) : TokenReviewStatus = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: io.k8s.api.authentication.v1.UserInfo => io.k8s.api.authentication.v1.UserInfo) : TokenReviewStatus = copy(user = user.map(f))
}

object TokenReviewStatus {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.authentication.v1.TokenReviewStatus, T] = new Encoder[io.k8s.api.authentication.v1.TokenReviewStatus, T] {
        def apply(o: io.k8s.api.authentication.v1.TokenReviewStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("audiences", o.audiences)
            .write("authenticated", o.authenticated)
            .write("error", o.error)
            .write("user", o.user)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, TokenReviewStatus] = new Decoder[T, TokenReviewStatus] {
      def apply(t: T): Either[String, TokenReviewStatus] = for {
          obj <- ObjectReader(t)
          audiences <- obj.readOpt[Seq[String]]("audiences")
          authenticated <- obj.readOpt[Boolean]("authenticated")
          error <- obj.readOpt[String]("error")
          user <- obj.readOpt[io.k8s.api.authentication.v1.UserInfo]("user")
      } yield TokenReviewStatus (
          audiences = audiences,
          authenticated = authenticated,
          error = error,
          user = user
        )
    }
}

