package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates. */
final case class StatefulSetPersistentVolumeClaimRetentionPolicy(
  whenDeleted : Option[String] = None,
  whenScaled : Option[String] = None
) {

  /** Returns a new data with whenDeleted set to new value */
  def withWhenDeleted(value: String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenDeleted = Some(value))
  /** if whenDeleted has a value, transforms to the result of function*/
  def mapWhenDeleted(f: String => String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenDeleted = whenDeleted.map(f))

  /** Returns a new data with whenScaled set to new value */
  def withWhenScaled(value: String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenScaled = Some(value))
  /** if whenScaled has a value, transforms to the result of function*/
  def mapWhenScaled(f: String => String) : StatefulSetPersistentVolumeClaimRetentionPolicy = copy(whenScaled = whenScaled.map(f))
}

object StatefulSetPersistentVolumeClaimRetentionPolicy {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy, T] = new Encoder[io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy, T] {
        def apply(o: io.k8s.api.apps.v1.StatefulSetPersistentVolumeClaimRetentionPolicy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("whenDeleted", o.whenDeleted)
            .write("whenScaled", o.whenScaled)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, StatefulSetPersistentVolumeClaimRetentionPolicy] = new Decoder[T, StatefulSetPersistentVolumeClaimRetentionPolicy] {
      def apply(t: T): Either[String, StatefulSetPersistentVolumeClaimRetentionPolicy] = for {
          obj <- ObjectReader(t)
          whenDeleted <- obj.readOpt[String]("whenDeleted")
          whenScaled <- obj.readOpt[String]("whenScaled")
      } yield StatefulSetPersistentVolumeClaimRetentionPolicy (
          whenDeleted = whenDeleted,
          whenScaled = whenScaled
        )
    }
}

