package io.k8s.api.apps.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** StatefulSetList is a collection of StatefulSets. */
final case class StatefulSetList(
  items : Seq[io.k8s.api.apps.v1.StatefulSet],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "StatefulSetList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.apps.v1.StatefulSet]) : StatefulSetList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.apps.v1.StatefulSet*) : StatefulSetList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.apps.v1.StatefulSet] => Seq[io.k8s.api.apps.v1.StatefulSet]) : StatefulSetList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StatefulSetList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StatefulSetList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = StatefulSetList.encoder[T].apply(this)
}

object StatefulSetList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.StatefulSetList, T] = new Encoder[io.k8s.api.apps.v1.StatefulSetList, T] {
        def apply(o: io.k8s.api.apps.v1.StatefulSetList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, StatefulSetList] = new Decoder[T, StatefulSetList] {
      def apply(t: T): Either[String, StatefulSetList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.apps.v1.StatefulSet]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield StatefulSetList (
          items = items,
          metadata = metadata
        )
    }
}

