package io.k8s.api.apps.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** DeploymentList is a list of Deployments. */
final case class DeploymentList(
  items : Seq[io.k8s.api.apps.v1.Deployment],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apps", "DeploymentList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.apps.v1.Deployment]) : DeploymentList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.apps.v1.Deployment*) : DeploymentList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.apps.v1.Deployment] => Seq[io.k8s.api.apps.v1.Deployment]) : DeploymentList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : DeploymentList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : DeploymentList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = DeploymentList.encoder[T].apply(this)
}

object DeploymentList {

    implicit def encoder[T](implicit builder : Builder[T]) : Encoder[io.k8s.api.apps.v1.DeploymentList, T] = new Encoder[io.k8s.api.apps.v1.DeploymentList, T] {
        def apply(o: io.k8s.api.apps.v1.DeploymentList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit def decoderOf[T : Reader] : Decoder[T, DeploymentList] = new Decoder[T, DeploymentList] {
      def apply(t: T): Either[String, DeploymentList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.apps.v1.Deployment]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield DeploymentList (
          items = items,
          metadata = metadata
        )
    }
}

